/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCalculus.volumeBetweenGrids;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.text.DecimalFormat;

public class VolumeBetweenGridsAlgorithm
extends GeoAlgorithm {
    public static final String VOL = "VOL";
    public static final String LGRID = "LGRID";
    public static final String UGRID = "UGRID";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_LowerGrid;
    private IRasterLayer m_UpperGrid;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_LowerGrid = this.m_Parameters.getParameterValueAsRasterLayer(LGRID);
        this.m_UpperGrid = this.m_Parameters.getParameterValueAsRasterLayer(UGRID);
        this.m_LowerGrid.setWindowExtent(this.m_AnalysisExtent);
        this.m_UpperGrid.setWindowExtent(this.m_AnalysisExtent);
        this.m_iNX = this.m_LowerGrid.getNX();
        this.m_iNY = this.m_LowerGrid.getNY();
        return this.calculateVolumes();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Volumen_between_two_layers"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(LGRID, Sextante.getText((String)"Lower_layer"), true);
            this.m_Parameters.addInputRasterLayer(UGRID, Sextante.getText((String)"Upper_layer"), true);
            this.addOutputText(VOL, Sextante.getText((String)"Volume"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private boolean calculateVolumes() {
        double dVolumePos = 0.0;
        double dVolumeNeg = 0.0;
        double dVolume = 0.0;
        double dArea = this.m_LowerGrid.getWindowCellSize() * this.m_LowerGrid.getWindowCellSize();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double z = this.m_LowerGrid.getCellValueAsDouble(x, y);
                double z2 = this.m_UpperGrid.getCellValueAsDouble(x, y);
                if (this.m_LowerGrid.isNoDataValue(z) || this.m_UpperGrid.isNoDataValue(z2)) continue;
                double dDif = z2 - z;
                dVolume += Math.abs(dDif);
                if (dDif > 0.0) {
                    dVolumePos += dDif;
                    continue;
                }
                dVolumeNeg += -dDif;
            }
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        dVolume *= dArea;
        dVolumePos *= dArea;
        dVolumeNeg *= dArea;
        DecimalFormat df = new DecimalFormat("##.##");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Volumes"));
        doc.addHeader(Sextante.getText((String)"Volumes"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Volume_+") + df.format(dVolumePos));
        doc.addListElement(Sextante.getText((String)"Volume_-") + df.format(dVolumeNeg));
        doc.addListElement(Sextante.getText((String)"Total_volume") + df.format(dVolume));
        doc.close();
        this.addOutputText(VOL, Sextante.getText((String)"Volume"), doc.getHTMLCode());
        return true;
    }
}

