/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridCategorical.filterClumps;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.Point;
import java.util.ArrayList;

public class FilterClumpsAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String INPUT = "INPUT";
    public static final String MINAREA = "MINAREA";
    public static final String RESULT = "RESULT";
    int m_iArea;
    int m_iNX;
    int m_iNY;
    IRasterLayer m_Grid;
    IRasterLayer m_Result;
    boolean[][] m_IsCellAlreadyVisited;
    boolean[][] m_IsCellAlreadyVisitedArea;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Filter_clumps"));
        this.setGroup(Sextante.getText((String)"Raster_categories_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addNumericalValue(MINAREA, Sextante.getText((String)"Min_area_[cells]"), 1, 100.0, 1.0, 2.147483647E9);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Filtered_layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Grid = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        this.m_iArea = this.m_Parameters.getParameterValueAsInt(MINAREA);
        this.m_Result = this.getNewRasterLayer(RESULT, this.m_Grid.getName() + "[filt]", 3);
        this.m_Grid.setWindowExtent(this.m_Result);
        this.m_Grid.setInterpolationMethod(0);
        this.m_iNX = this.m_Grid.getNX();
        this.m_iNY = this.m_Grid.getNY();
        this.m_IsCellAlreadyVisited = new boolean[this.m_iNX][this.m_iNY];
        this.m_IsCellAlreadyVisitedArea = new boolean[this.m_iNX][this.m_iNY];
        this.m_Result.assign(this.m_Grid);
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                if (this.m_IsCellAlreadyVisited[x][y]) continue;
                int iArea = this.getArea(x, y);
                if (iArea < this.m_iArea) {
                    this.setToNoData(x, y);
                    continue;
                }
                int n = iArea + 1;
            }
        }
        return !this.m_Task.isCanceled();
    }

    private int getArea(int x, int y) {
        int iArea = 1;
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        if (this.m_IsCellAlreadyVisitedArea[x][y]) {
            return Integer.MAX_VALUE;
        }
        int iInitClass = this.m_Grid.getCellValueAsInt(x, y);
        centralPoints.add(new Point(x, y));
        this.m_IsCellAlreadyVisitedArea[x][y] = true;
        while (centralPoints.size() != 0) {
            for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                Point point = (Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                int iClass = this.m_Grid.getCellValueAsInt(x, y);
                if (this.m_Grid.isNoDataValue((double)iClass)) continue;
                for (int n = 0; n < 8; ++n) {
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    iClass = this.m_Grid.getCellValueAsInt(x2, y2);
                    if (this.m_Grid.isNoDataValue((double)iClass) || this.m_IsCellAlreadyVisitedArea[x2][y2] || iInitClass != iClass) continue;
                    this.m_IsCellAlreadyVisitedArea[x2][y2] = true;
                    adjPoints.add(new Point(x2, y2));
                    ++iArea;
                }
            }
            centralPoints = adjPoints;
            adjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return Integer.MAX_VALUE;
        }
        return iArea;
    }

    private void setToNoData(int x, int y) {
        ArrayList<Point> centralPoints = new ArrayList<Point>();
        ArrayList<Point> adjPoints = new ArrayList<Point>();
        int iInitClass = this.m_Result.getCellValueAsInt(x, y);
        centralPoints.add(new Point(x, y));
        while (centralPoints.size() != 0) {
            for (int iPt = 0; iPt < centralPoints.size(); ++iPt) {
                Point point = (Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                int iClass = this.m_Result.getCellValueAsInt(x, y);
                if (this.m_Result.isNoDataValue((double)iClass)) continue;
                this.m_Result.setNoData(x, y);
                for (int n = 0; n < 8; ++n) {
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    iClass = this.m_Result.getCellValueAsInt(x2, y2);
                    if (this.m_Result.isNoDataValue((double)iClass) || iInitClass != iClass) continue;
                    adjPoints.add(new Point(x2, y2));
                }
            }
            centralPoints = adjPoints;
            adjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
    }
}

