/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridStatistics.base;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.NullParameterValueException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.exceptions.WrongParameterTypeException;
import java.util.ArrayList;

public abstract class MultiGridStatsExtendedBaseAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String VALUE = "VALUE";
    public static final String FORCE_NODATA = "NODATA";
    public static final String RESULT = "RESULT";
    protected double NO_DATA;
    protected double m_dValue;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Layers"), 1, true);
            this.m_Parameters.addNumericalValue(VALUE, Sextante.getText((String)"Value"), 0.0, 2);
            this.m_Parameters.addBoolean(FORCE_NODATA, Sextante.getText((String)"Force_no-data_value"), true);
            this.addOutputRasterLayer(RESULT, this.getName());
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.NO_DATA = this.m_OutputFactory.getDefaultNoDataValue();
        try {
            int i;
            ArrayList input = this.m_Parameters.getParameterValueAsArrayList(INPUT);
            boolean bForceNoData = this.m_Parameters.getParameterValueAsBoolean(FORCE_NODATA);
            this.m_dValue = this.m_Parameters.getParameterValueAsDouble(VALUE);
            if (input.size() == 0) {
                return false;
            }
            IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5);
            result.setNoDataValue(this.NO_DATA);
            result.assignNoData();
            IRasterLayer[] window = new IRasterLayer[input.size()];
            for (i = 0; i < input.size(); ++i) {
                window[i] = (IRasterLayer)input.get(i);
                window[i].setWindowExtent(result.getWindowGridExtent());
                if (window[i].getDataType() == 4 || window[i].getDataType() == 5) {
                    window[i].setInterpolationMethod(4);
                    continue;
                }
                window[i].setInterpolationMethod(0);
            }
            int iNX = window[0].getNX();
            int iNY = window[0].getNY();
            double[] dValues = new double[input.size()];
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    for (i = 0; i < window.length; ++i) {
                        double dValue = window[i].getCellValueAsDouble(x, y);
                        if (!window[i].isNoDataValue(dValue)) {
                            dValues[i] = dValue;
                            continue;
                        }
                        if (bForceNoData) {
                            result.setNoData(x, y);
                            break;
                        }
                        dValues[i] = this.NO_DATA;
                    }
                    result.setCellValue(x, y, this.processValues(dValues));
                }
            }
            return !this.m_Task.isCanceled();
        }
        catch (WrongParameterTypeException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (NullParameterValueException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return false;
    }

    protected abstract double processValues(double[] var1);
}

