/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.gridOrientation;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class GridOrientationAlgorithm
extends GeoAlgorithm {
    public static final String METHOD = "METHOD";
    public static final String INPUT = "INPUT";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_Window;
    private IRasterLayer m_Result;
    public static final int MIRROR_HORIZONTAL = 0;
    public static final int MIRROR_VERTICAL = 1;
    public static final int INVERT = 2;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Mirror_horizontally"), Sextante.getText((String)"Mirror_vertically"), Sextante.getText((String)"Invert")};
        this.setName(Sextante.getText((String)"Mirror-flip"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"M\u00e9todo"), sMethod);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String[] sMethod = new String[]{Sextante.getText((String)"[mirrored]"), Sextante.getText((String)"[mirrored]"), Sextante.getText((String)"[Inverted]")};
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        AnalysisExtent gridExtent = new AnalysisExtent((ILayer)this.m_Window);
        this.m_Window.setWindowExtent(gridExtent);
        this.m_Result = this.getNewRasterLayer(RESULT, this.m_Window.getName() + sMethod[iMethod], this.m_Window.getDataType(), gridExtent);
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        switch (iMethod) {
            case 0: {
                this.mirrorHorizontally();
                break;
            }
            case 1: {
                this.mirrorVertically();
                break;
            }
            case 2: {
                this.invert();
                break;
            }
        }
        return !this.m_Task.isCanceled();
    }

    private void mirrorHorizontally() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.m_Result.setCellValue(this.m_iNX - x - 1, y, this.m_Window.getCellValueAsDouble(x, y));
            }
        }
    }

    private void mirrorVertically() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.m_Result.setCellValue(x, this.m_iNY - y - 1, this.m_Window.getCellValueAsDouble(x, y));
            }
            this.setProgress(y, this.m_iNY);
        }
    }

    private void invert() {
        double z;
        int x;
        int y;
        double dMin = 0.0;
        double dMax = 0.0;
        int A = 0;
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                z = this.m_Window.getCellValueAsFloat(x, y);
                if (this.m_Window.isNoDataValue(z)) continue;
                if (A <= 0) {
                    dMin = dMax = z;
                } else if (dMin > z) {
                    dMin = z;
                } else if (dMax < z) {
                    dMax = z;
                }
                ++A;
            }
            this.setProgress(y, this.m_iNY);
        }
        for (y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (x = 0; x < this.m_iNX; ++x) {
                z = this.m_Window.getCellValueAsFloat(x, y);
                if (this.m_Window.isNoDataValue(z)) {
                    this.m_Result.setNoData(x, y);
                    continue;
                }
                this.m_Result.setCellValue(x, y, dMax - z + dMin);
            }
        }
    }
}

