/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.invertNoData;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class InvertNoDataAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String INPUT = "INPUT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Invert_mask"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Layer"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Inverted_mask"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        IRasterLayer result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Inverted_mask"), 0);
        result.setNoDataValue(0.0);
        input.setWindowExtent(result.getWindowGridExtent());
        int iNX = result.getWindowGridExtent().getNX();
        int iNY = result.getWindowGridExtent().getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dValue = input.getCellValueAsDouble(x, y);
                if (input.isNoDataValue(dValue)) {
                    result.setCellValue(x, y, 1.0);
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

