/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gridTools.mergeGrids;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class MergeGridsAlgorithm
extends GeoAlgorithm {
    public static final String METHOD = "METHOD";
    public static final String INPUT = "INPUT";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Nearest_neighbour"), Sextante.getText((String)"Bilinear"), Sextante.getText((String)"Inverse_distance"), Sextante.getText((String)"Cubic_spline"), Sextante.getText((String)"B-spline")};
        this.setName(Sextante.getText((String)"Merge_grids"));
        this.setGroup(Sextante.getText((String)"Basic_tools_for_raster_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Layers"), 1, true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Interpolation_method"), sMethod);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Merged_grids"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        ArrayList input = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        if (input.size() == 0) {
            return false;
        }
        boolean bAddWarning = false;
        int iBands = ((IRasterLayer)input.get(0)).getBandsCount();
        for (i = 0; i < input.size(); ++i) {
            IRasterLayer layer = (IRasterLayer)input.get(i);
            if (layer.getBandsCount() == iBands) continue;
            iBands = Math.max(layer.getBandsCount(), iBands);
            bAddWarning = true;
        }
        if (bAddWarning) {
            Sextante.addWarningToLog((String)Sextante.getText((String)"Layers_to_be_merged_have_different_number_of_bands"));
        }
        IRasterLayer result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Merged_grids"), ((IRasterLayer)input.get(0)).getDataType(), iBands);
        result.assignNoData();
        IRasterLayer[] window = new IRasterLayer[input.size()];
        for (i = 0; i < input.size(); ++i) {
            window[i] = (IRasterLayer)input.get(i);
            window[i].setWindowExtent(result.getWindowGridExtent());
            window[i].setInterpolationMethod(iMethod);
        }
        int iNX = window[0].getNX();
        int iNY = window[0].getNY();
        for (int iBand = 0; iBand < iBands; ++iBand) {
            for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (int x = 0; x < iNX; ++x) {
                    double dValueSum = 0.0;
                    double dValidValues = 0.0;
                    for (i = 0; i < window.length; ++i) {
                        double dValue = window[i].getCellValueAsDouble(x, y, iBand);
                        if (window[i].isNoDataValue(dValue)) continue;
                        dValidValues += 1.0;
                        dValueSum += dValue;
                    }
                    if (dValidValues == 0.0) {
                        result.setNoData(x, y);
                        continue;
                    }
                    result.setCellValue(x, y, iBand, dValueSum / dValidValues);
                }
            }
        }
        return !this.m_Task.isCanceled();
    }
}

