/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.burnStreams;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;

public class BurnStreamsAlgorithm
extends GeoAlgorithm {
    public static final String STREAMS = "STREAMS";
    public static final String DEM = "DEM";
    public static final String RESULT = "RESULT";
    public static final String DEPTH = "DEPTH";
    private static final double SMALL_DIFFERENCE = 0.05;
    private IRasterLayer m_DEM;
    private IRasterLayer m_Result;
    private double m_dLastZ;
    private double m_dDepth;
    private boolean m_bFoundValidCell;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_dDepth = this.m_Parameters.getParameterValueAsDouble(DEPTH);
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(STREAMS);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_DEM.setFullExtent();
        AnalysisExtent extent = this.m_DEM.getWindowGridExtent();
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Modified_DEM"), 5, extent);
        this.m_Result.assign(this.m_DEM);
        int iShape = 0;
        int iShapeCount = lines.getShapesCount();
        IFeatureIterator iterator = lines.iterator();
        while (iterator.hasNext() && this.setProgress(iShape, iShapeCount)) {
            Geometry line = iterator.next().getGeometry();
            for (int i = 0; i < line.getNumGeometries(); ++i) {
                this.processLine(line.getGeometryN(i));
            }
            ++iShape;
        }
        iterator.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Burn_streams"));
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(STREAMS, Sextante.getText((String)"Channel_network"), 1, true);
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addNumericalValue(DEPTH, Sextante.getText((String)"Depth"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Modified_DEM"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void processLine(Geometry line) {
        Coordinate[] coords = line.getCoordinates();
        this.m_bFoundValidCell = false;
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            this.processSegment(x, y, x2, y2);
        }
    }

    private void processSegment(double x, double y, double x2, double y2) {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= this.m_DEM.getWindowCellSize();
                dy /= dx;
                dx = this.m_DEM.getWindowCellSize();
            } else {
                n = dy /= this.m_DEM.getWindowCellSize();
                dx /= dy;
                dy = this.m_DEM.getWindowCellSize();
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                this.addPoint(x, y);
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    private void addPoint(double x, double y) {
        int iY;
        GridCell cell = this.m_DEM.getWindowGridExtent().getGridCoordsFromWorldCoords(x, y);
        int iX = cell.getX();
        double z = this.m_DEM.getCellValueAsDouble(iX, iY = cell.getY());
        if (this.m_DEM.isNoDataValue(z)) {
            return;
        }
        if (!this.m_bFoundValidCell) {
            this.m_dLastZ = z - this.m_dDepth;
            this.m_bFoundValidCell = true;
        }
        this.m_dLastZ -= 0.05;
        this.m_Result.setCellValue(iX, iY, this.m_dLastZ);
    }
}

