/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.cellBalance;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CellBalanceAlgorithm
extends GeoAlgorithm {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String WEIGHTS = "WEIGHTS";
    public static final String CONVERGENCE = "CONVERGENCE";
    public static final String CELLBALANCE = "CELLBALANCE";
    private int m_iMethod;
    private int m_iNX;
    private int m_iNY;
    private double m_dConvergence;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Weights = null;
    private IRasterLayer m_CellBalance;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Weights = this.m_Parameters.getParameterValueAsRasterLayer(WEIGHTS);
        this.m_dConvergence = this.m_Parameters.getParameterValueAsDouble(CONVERGENCE);
        this.m_CellBalance = this.getNewRasterLayer(CELLBALANCE, Sextante.getText((String)"Net_balance"), 4);
        AnalysisExtent extent = this.m_CellBalance.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        this.m_Weights.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateInFlows();
        this.substractOutFlows();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"D8"), Sextante.getText((String)"DInfinity"), Sextante.getText((String)"MFD__Multiple_Flow_Directions")};
        this.setName(Sextante.getText((String)"Net_balance"));
        this.setGroup(Sextante.getText((String)"Indices_and_other_hydrological_parameters"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(WEIGHTS, Sextante.getText((String)"Weight"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(CONVERGENCE, Sextante.getText((String)"Convergence_factor__MFD"), 1.1, 2);
            this.addOutputRasterLayer(CELLBALANCE, Sextante.getText((String)"Net_balance"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateInFlows() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            block6: for (int x = 0; x < this.m_iNX; ++x) {
                switch (this.m_iMethod) {
                    case 0: {
                        this.doD8(x, y);
                        continue block6;
                    }
                    case 1: {
                        this.doDInf(x, y);
                        continue block6;
                    }
                    case 2: {
                        this.doMFD(x, y);
                    }
                }
            }
        }
    }

    private void substractOutFlows() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dOut = this.m_Weights.getCellValueAsDouble(x, y);
                if (!this.m_Weights.isNoDataValue(dOut)) {
                    this.m_CellBalance.addToCellValue(x, y, -dOut);
                    continue;
                }
                this.m_CellBalance.setNoData(x, y);
            }
        }
    }

    private void doD8(int x, int y) {
        int iDirection;
        double dWeight = this.m_Weights.getCellValueAsDouble(x, y);
        if (!this.m_Weights.isNoDataValue(dWeight) && (iDirection = this.m_DEM.getDirToNextDownslopeCell(x, y)) >= 0) {
            int ix = x + m_iOffsetX[iDirection];
            int iy = y + m_iOffsetY[iDirection];
            this.m_CellBalance.addToCellValue(ix, iy, dWeight);
        }
    }

    private void doDInf(int x, int y) {
        double dWeight = this.m_Weights.getCellValueAsDouble(x, y);
        if (!this.m_Weights.isNoDataValue(dWeight)) {
            double dAspect = this.m_DEM.getAspect(x, y);
            if ((dAspect *= 57.29577951308232) >= 0.0) {
                int iDirection = (int)(dAspect / 45.0);
                dAspect = dAspect % 45.0 / 45.0;
                int ix = x + m_iOffsetX[iDirection %= 8];
                int iy = y + m_iOffsetY[iDirection];
                this.m_CellBalance.addToCellValue(ix, iy, dWeight * (1.0 - dAspect));
                iDirection = (iDirection + 1) % 8;
                ix = x + m_iOffsetX[iDirection];
                iy = y + m_iOffsetY[iDirection];
                this.m_CellBalance.addToCellValue(ix, iy, dWeight * dAspect);
            }
        }
    }

    private void doMFD(int x, int y) {
        double dWeight = this.m_Weights.getCellValueAsDouble(x, y);
        if (!this.m_Weights.isNoDataValue(dWeight)) {
            int iy;
            int ix;
            int i;
            double z = this.m_DEM.getCellValueAsDouble(x, y);
            double dzSum = 0.0;
            double[] Flow = new double[8];
            for (i = 0; i < 8; ++i) {
                double dDifZ;
                ix = x + m_iOffsetX[i];
                iy = y + m_iOffsetY[i];
                double z2 = this.m_DEM.getCellValueAsDouble(ix, iy);
                if (this.m_DEM.isNoDataValue(z2) || !((dDifZ = z - z2) > 0.0)) continue;
                Flow[i] = Math.pow(dDifZ / this.m_DEM.getDistToNeighborInDir(i), this.m_dConvergence);
                dzSum += Flow[i];
            }
            if (dzSum > 0.0) {
                for (i = 0; i < 8; ++i) {
                    ix = x + m_iOffsetX[i];
                    iy = y + m_iOffsetY[i];
                    if (!(Flow[i] > 0.0)) continue;
                    this.m_CellBalance.addToCellValue(ix, iy, Flow[i] / dzSum * dWeight);
                }
            }
        }
    }
}

