/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.upslopeAreaFromArea;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class UpslopeAreaFromAreaAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private static final double NOT_VISITED = 0.0;
    private static final double VISITED = 1.0;
    public static final String DEM = "DEM";
    public static final String INITZONES = "INITZONES";
    public static final String RESULT = "RESULT";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_InitZone = null;
    private IRasterLayer m_Result;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_InitZone = this.m_Parameters.getParameterValueAsRasterLayer(INITZONES);
        this.m_DEM.setFullExtent();
        AnalysisExtent extent = this.m_DEM.getWindowGridExtent();
        this.m_InitZone.setWindowExtent(extent);
        this.m_InitZone.setInterpolationMethod(0);
        this.m_Result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Upslope_area"), 0, extent);
        this.m_Result.assign(0.0);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateUpslopeArea();
        this.m_Result.setNoDataValue(0.0);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Upslope_area_from_outlet_zone"));
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        this.setUserCanDefineAnalysisExtent(false);
        this.setIsDeterminatedProcess(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(INITZONES, Sextante.getText((String)"Outlet_zone"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Upslope_area"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateUpslopeArea() {
        for (int y = 0; y < this.m_iNY; ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_InitZone.getCellValueAsDouble(x, y);
                if (this.m_InitZone.isNoDataValue(dValue)) continue;
                this.calculateUpslopeAreaFromPoint(x, y);
            }
        }
    }

    private void calculateUpslopeAreaFromPoint(int x, int y) {
        if (this.m_Result.getCellValueAsDouble(x, y) != 0.0 || this.m_Task.isCanceled()) {
            return;
        }
        double dValue = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return;
        }
        this.m_Result.setCellValue(x, y, 1.0);
        for (int i = 0; i < 8; ++i) {
            int iDirection;
            int ix = x + m_iOffsetX[i];
            int iy = y + m_iOffsetY[i];
            dValue = this.m_DEM.getCellValueAsDouble(ix, iy);
            if (this.m_DEM.isNoDataValue(dValue) || (iDirection = this.m_DEM.getDirToNextDownslopeCell(ix, iy)) < 0 || (i + 4) % 8 != iDirection) continue;
            this.calculateUpslopeAreaFromPoint(ix, iy);
        }
    }
}

