/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.hydrology.watersheds;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.util.ArrayList;
import java.util.Arrays;

public class WatershedsAlgorithm
extends GeoAlgorithm {
    private static final int NO_BASIN = -1;
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String NETWORK = "NETWORK";
    public static final String MINSIZE = "MINSIZE";
    public static final String WATERSHEDS = "WATERSHEDS";
    private int m_iBasins;
    private int m_iNX;
    private int m_iNY;
    private int m_iMinSize;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_Network = null;
    private IRasterLayer m_Basins;
    private IRasterLayer m_Directions;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Network = this.m_Parameters.getParameterValueAsRasterLayer(NETWORK);
        this.m_iMinSize = this.m_Parameters.getParameterValueAsInt(MINSIZE);
        this.m_Basins = this.getNewRasterLayer(WATERSHEDS, Sextante.getText((String)"Watersheds"), 3);
        this.m_Basins.setNoDataValue(-1.0);
        this.m_Basins.assignNoData();
        AnalysisExtent extent = this.m_Basins.getWindowGridExtent();
        this.m_DEM.setFullExtent();
        this.m_Network.setWindowExtent(extent);
        this.m_Directions = this.getTempRasterLayer(3, extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.calculateBasins();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Watersheds"));
        this.setGroup(Sextante.getText((String)"Basic_hydrological_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addInputRasterLayer(NETWORK, Sextante.getText((String)"Channel_network"), true);
            this.m_Parameters.addNumericalValue(MINSIZE, Sextante.getText((String)"Minimum_watershed_size__cells"), 0.0, 1);
            this.addOutputRasterLayer(WATERSHEDS, Sextante.getText((String)"Watersheds"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateBasins() {
        this.prepareDirectionsLayer();
        ArrayList outletsArrayList = this.getOutlets();
        Object[] outlets = outletsArrayList.toArray();
        Arrays.sort(outlets);
        this.m_iBasins = 0;
        for (int i = outlets.length - 1; i >= 0 && this.setProgress(outlets.length - i, outlets.length); --i) {
            int y;
            ++this.m_iBasins;
            int x = ((GridCell)outlets[i]).getX();
            if (this.getBasin(x, y = ((GridCell)outlets[i]).getY()) >= this.m_iMinSize) continue;
            int iBasins = this.m_iBasins - 1;
            this.m_iBasins = -1;
            this.getBasin(x, y);
            this.m_iBasins = iBasins;
        }
    }

    private void prepareDirectionsLayer() {
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                int iDir = this.m_DEM.getDirToNextDownslopeCell(x, y, false);
                if (iDir < 0) {
                    this.m_Directions.setCellValue(x, y, -1.0);
                    continue;
                }
                this.m_Directions.setCellValue(x, y, (double)((iDir + 4) % 8));
            }
        }
    }

    private ArrayList getOutlets() {
        ArrayList outlets = new ArrayList();
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.addOutlet(x, y, outlets);
            }
        }
        return outlets;
    }

    private void addOutlet(int x, int y, ArrayList outlets) {
        int iUpslopeX = 0;
        int iUpslopeY = 0;
        int iUpslopeRiverCells = 0;
        double dUpslopeZ = 0.0;
        int iNetwork = this.m_Network.getCellValueAsInt(x, y);
        int iDir = this.m_Directions.getCellValueAsInt(x, y);
        double dZ = this.m_DEM.getCellValueAsDouble(x, y);
        int iNextCellX = x + m_iOffsetX[(iDir + 4) % 8];
        int iNextCellY = y + m_iOffsetY[(iDir + 4) % 8];
        int iNextCellNetwork = this.m_Network.getCellValueAsInt(iNextCellX, iNextCellY);
        if (this.m_Network.isNoDataValue((double)iNetwork) || iNetwork == 0) {
            return;
        }
        if (this.m_Network.isNoDataValue((double)iNextCellNetwork) || iNextCellNetwork == 0) {
            outlets.add(new GridCell(x, y, dZ));
        } else {
            if (iNetwork < 0) {
                outlets.add(new GridCell(x, y, dZ));
                return;
            }
            if (iDir == -1 && !this.m_DEM.isNoDataValue(dZ)) {
                outlets.add(new GridCell(x, y, dZ));
            } else {
                for (int i = 0; i < 8; ++i) {
                    int ix = x + m_iOffsetX[i];
                    int iy = y + m_iOffsetY[i];
                    if (this.m_Directions.getCellValueAsInt(ix, iy) != i || (iNetwork = this.m_Network.getCellValueAsInt(ix, iy)) <= 0 || this.m_Network.isNoDataValue((double)iNetwork)) continue;
                    if (iUpslopeRiverCells > 0) {
                        if (iUpslopeRiverCells == 1) {
                            outlets.add(new GridCell(iUpslopeX, iUpslopeY, dUpslopeZ));
                        }
                        outlets.add(new GridCell(ix, iy, this.m_DEM.getCellValueAsDouble(ix, iy)));
                    } else {
                        iUpslopeX = ix;
                        iUpslopeY = iy;
                        dUpslopeZ = this.m_DEM.getCellValueAsDouble(x, y);
                    }
                    ++iUpslopeRiverCells;
                }
            }
        }
    }

    private int getBasin(int x, int y) {
        int nCells = 1;
        int iBasin = this.m_Basins.getCellValueAsInt(x, y);
        int iDir = this.m_Directions.getCellValueAsInt(x, y);
        if (iBasin == -1 && !this.m_Directions.isNoDataValue((double)iDir)) {
            this.m_Basins.setCellValue(x, y, (double)this.m_iBasins);
            nCells = 1;
            for (int i = 0; i < 8; ++i) {
                int ix = x + m_iOffsetX[i];
                int iy = y + m_iOffsetY[i];
                if (this.m_Directions.getCellValueAsInt(ix, iy) != i || this.m_Basins.getCellValueAsInt(ix, iy) != -1) continue;
                nCells += this.getBasin(ix, iy);
            }
            return nCells;
        }
        return 0;
    }
}

