/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.texture.base;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public abstract class BaseTextureAnalysisAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String WINDOW_RADIUS = "WINDOW_RADIUS";
    public static final String RESULT = "RESULT";
    public static final String SHIFTX = "SHIFTX";
    public static final String SHIFTY = "SHIFTY";
    public static final int GRAYSCALE_LEVELS = 16;
    private IRasterLayer m_Image;
    protected byte[][] m_GLCM;
    private int m_iWindowRadius;
    private int m_iWindowSize;
    private int m_iShiftX;
    private int m_iShiftY;
    private double m_ProbabilityFraction;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Image_processing"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Image"), true);
            this.m_Parameters.addNumericalValue(WINDOW_RADIUS, Sextante.getText((String)"Window_radius"), 1, 2.0, 1.0, 15.0);
            this.m_Parameters.addNumericalValue(SHIFTX, Sextante.getText((String)"ShiftX"), 1, 1.0, 1.0, 15.0);
            this.m_Parameters.addNumericalValue(SHIFTY, Sextante.getText((String)"ShiftY"), 1, 1.0, 1.0, 15.0);
        }
        catch (RepeatedParameterNameException e) {
            e.printStackTrace();
        }
        this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iNX = this.m_AnalysisExtent.getNX();
        int iNY = this.m_AnalysisExtent.getNY();
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 5);
        this.m_Image = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_iWindowRadius = this.m_Parameters.getParameterValueAsInt(WINDOW_RADIUS);
        this.m_iShiftX = this.m_Parameters.getParameterValueAsInt(SHIFTX);
        this.m_iShiftY = this.m_Parameters.getParameterValueAsInt(SHIFTY);
        this.m_iWindowSize = this.m_iWindowRadius * 2 + 1;
        this.m_GLCM = new byte[16][16];
        this.m_ProbabilityFraction = 1.0 / (double)((this.m_iWindowSize - this.m_iShiftY) * (this.m_iWindowSize - this.m_iShiftY));
        for (int y = this.m_iWindowRadius; y < iNY - this.m_iWindowRadius && this.setProgress(y, iNY); ++y) {
            for (int x = this.m_iWindowRadius; x < iNX - this.m_iWindowRadius; ++x) {
                if (this.calculateGLCM(x, y)) {
                    result.setCellValue(x, y, this.getTextureFeature());
                    continue;
                }
                result.setNoData(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    private boolean calculateGLCM(int x, int y) throws GeoAlgorithmExecutionException {
        x -= this.m_iWindowRadius;
        y -= this.m_iWindowRadius;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.m_GLCM[i][j] = 0;
            }
        }
        try {
            for (int iX = 0; iX < this.m_iWindowRadius - this.m_iShiftX; ++iX) {
                for (int iY = 0; iY < this.m_iWindowRadius - this.m_iShiftY; ++iY) {
                    byte valueA = this.m_Image.getCellValueAsByte(x + iX, y + iY);
                    if (this.m_Image.isNoDataValue((double)valueA)) {
                        return false;
                    }
                    byte valueB = this.m_Image.getCellValueAsByte(x + iX + this.m_iShiftX, y + iY + this.m_iShiftY);
                    if (this.m_Image.isNoDataValue((double)valueB)) {
                        return false;
                    }
                    byte[] byArray = this.m_GLCM[valueA];
                    byte by = valueB;
                    byArray[by] = (byte)((double)byArray[by] + this.m_ProbabilityFraction);
                    byte[] byArray2 = this.m_GLCM[valueB];
                    byte by2 = valueA;
                    byArray2[by2] = (byte)((double)byArray2[by2] + this.m_ProbabilityFraction);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GeoAlgorithmExecutionException("Wrong_input_layer_for_texture_analysis");
        }
        return true;
    }

    protected abstract double getTextureFeature();
}

