/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.thinning;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.Point;
import java.util.ArrayList;

public class ThinningAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1, 0};
    private static final int[] m_iOffsetY = new int[]{-1, -1, 0, 1, 1, 1, 0, -1, -1};
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    protected final byte NO_DATA = 0;
    private IRasterLayer m_Window;
    private IRasterLayer m_Result;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(false);
        this.setName(Sextante.getText((String)"Thinning"));
        this.setGroup(Sextante.getText((String)"Image_processing"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Image"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Thinned_image"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        boolean bFoundCell;
        int x;
        int y;
        int iIteration = 1;
        ArrayList<Point> marked = new ArrayList<Point>();
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Window.setFullExtent();
        this.m_Result = this.getNewRasterLayer(RESULT, this.getName(), 0, this.m_Window.getWindowGridExtent());
        this.m_Result.setNoDataValue(0.0);
        this.m_Result.assign(1.0);
        int iNX = this.m_Window.getNX();
        int iNY = this.m_Window.getNY();
        for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (x = 0; x < iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue) || dValue == 0.0) {
                    this.m_Result.setNoData(x, y);
                    continue;
                }
                this.m_Result.setCellValue(x, y, 1.0);
            }
        }
        do {
            Point pt;
            int i;
            bFoundCell = false;
            this.setProgressText(Sextante.getText((String)"Iteration") + " " + Integer.toString(iIteration++));
            for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (x = 0; x < iNX; ++x) {
                    if (this.m_Result.getCellValueAsByte(x, y) != 1 || !this.applyFirstCondition(x, y)) continue;
                    marked.add(new Point(x, y));
                    bFoundCell = true;
                }
            }
            if (!bFoundCell) break;
            for (i = 0; i < marked.size(); ++i) {
                pt = (Point)marked.get(i);
                this.m_Result.setNoData(pt.x, pt.y);
            }
            marked.clear();
            for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
                for (x = 0; x < iNX; ++x) {
                    if (this.m_Result.getCellValueAsByte(x, y) != 1 || !this.applySecondCondition(x, y)) continue;
                    marked.add(new Point(x, y));
                    bFoundCell = true;
                }
            }
            for (i = 0; i < marked.size(); ++i) {
                pt = (Point)marked.get(i);
                this.m_Result.setNoData(pt.x, pt.y);
            }
            marked.clear();
        } while (bFoundCell && !this.m_Task.isCanceled() && iIteration < 100);
        return !this.m_Task.isCanceled();
    }

    private boolean applyFirstCondition(int x, int y) {
        int iCount = 0;
        int iChanges = 0;
        byte byPrev = 1;
        for (int i = 0; i < 9; ++i) {
            byte byValue = this.m_Result.getCellValueAsByte(x + m_iOffsetX[i], y + m_iOffsetY[i]);
            if (byValue == 1) {
                ++iCount;
                if (byPrev == 0) {
                    ++iChanges;
                }
            }
            byPrev = byValue;
        }
        double pn = this.m_Result.getCellValueAsByte(x + m_iOffsetX[0], y + m_iOffsetY[0]);
        double pe = this.m_Result.getCellValueAsByte(x + m_iOffsetX[2], y + m_iOffsetY[2]);
        double ps = this.m_Result.getCellValueAsByte(x + m_iOffsetX[4], y + m_iOffsetY[4]);
        double pw = this.m_Result.getCellValueAsByte(x + m_iOffsetX[6], y + m_iOffsetY[6]);
        return pn * ps * pe == 0.0 && pw * pe * ps == 0.0 && iCount >= 2 && iCount <= 6 && iChanges == 1;
    }

    private boolean applySecondCondition(int x, int y) {
        double pw;
        int iCount = 0;
        int iChanges = 0;
        byte byPrev = 1;
        for (int i = 0; i < 9; ++i) {
            byte byValue = this.m_Result.getCellValueAsByte(x + m_iOffsetX[i], y + m_iOffsetY[i]);
            if (byValue == 1) {
                ++iCount;
                if (byPrev == 0) {
                    ++iChanges;
                }
            }
            byPrev = byValue;
        }
        double pn = this.m_Result.getCellValueAsByte(x + m_iOffsetX[0], y + m_iOffsetY[0]);
        double pe = this.m_Result.getCellValueAsByte(x + m_iOffsetX[2], y + m_iOffsetY[2]);
        double ps = this.m_Result.getCellValueAsByte(x + m_iOffsetX[4], y + m_iOffsetY[4]);
        return pn * ps * (pw = (double)this.m_Result.getCellValueAsByte(x + m_iOffsetX[6], y + m_iOffsetY[6])) == 0.0 && pw * pe * pn == 0.0 && iCount >= 2 && iCount <= 6 && iChanges == 1;
    }
}

