/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.fresnelLos;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class FresnelLOSAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String POINT = "POINT";
    public static final String POINT2 = "POINT2";
    public static final String HEIGHT = "HEIGHT";
    public static final String HEIGHT2 = "HEIGHT2";
    public static final String GRAPH = "GRAPH";
    public static final String LAMBDA = "LAMBDA";
    private IRasterLayer m_DEM = null;
    private GridCell m_Point;
    private GridCell m_Point2;
    private double m_dHeight;
    private double m_dHeight2;
    private final XYSeriesCollection m_Dataset = new XYSeriesCollection();
    private double m_dFrequency;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(POINT);
        Point2D pt2 = this.m_Parameters.getParameterValueAsPoint(POINT2);
        this.m_dHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHT);
        this.m_dHeight2 = this.m_Parameters.getParameterValueAsDouble(HEIGHT2);
        this.m_dFrequency = this.m_Parameters.getParameterValueAsDouble(LAMBDA);
        AnalysisExtent ge = new AnalysisExtent((ILayer)this.m_DEM);
        this.m_Point = ge.getGridCoordsFromWorldCoords(pt);
        this.m_Point2 = ge.getGridCoordsFromWorldCoords(pt2);
        double x = ge.getXMin() + (double)this.m_Point.getX() * ge.getCellSize();
        double y = ge.getYMax() - (double)this.m_Point.getY() * ge.getCellSize();
        double x2 = ge.getXMin() + (double)this.m_Point2.getX() * ge.getCellSize();
        double y2 = ge.getYMax() - (double)this.m_Point2.getY() * ge.getCellSize();
        ge.setXRange(x, x2, true);
        ge.setYRange(y, y2, true);
        ge.enlargeOneCell();
        this.m_Point = ge.getGridCoordsFromWorldCoords(pt);
        this.m_Point2 = ge.getGridCoordsFromWorldCoords(pt2);
        this.m_DEM.setWindowExtent(ge);
        this.calculateLOS(this.m_Point.getX(), this.m_Point.getY(), this.m_Point2.getX(), this.m_Point2.getY());
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"point") + " 1");
            this.m_Parameters.addPoint(POINT2, Sextante.getText((String)"point") + " 2");
            this.m_Parameters.addNumericalValue(HEIGHT, Sextante.getText((String)"Height_of_point") + " 1", 0.0, 2);
            this.m_Parameters.addNumericalValue(HEIGHT2, Sextante.getText((String)"Height_of_point") + " 2", 0.0, 2);
            this.m_Parameters.addNumericalValue(LAMBDA, Sextante.getText((String)"Wavelength"), 2, 0.0, 0.0, Double.MAX_VALUE);
            this.addOutputChart(GRAPH, Sextante.getText((String)"Line_of_sight"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.setName(Sextante.getText((String)"RF_Line_of_sight"));
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
    }

    private void calculateLOS(int x, int y, int x2, int y2) {
        double d;
        XYSeries serie = new XYSeries((Comparable)((Object)"serie"));
        XYSeries fresnelSerie = new XYSeries((Comparable)((Object)"fresnel"));
        XYSeries straightlineSerie = new XYSeries((Comparable)((Object)"straightline"));
        this.m_Dataset.addSeries(serie);
        this.m_Dataset.addSeries(straightlineSerie);
        this.m_Dataset.addSeries(fresnelSerie);
        double dx = x2 - x;
        double dy = y2 - y;
        double d2 = d = Math.abs(dx) > Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        if (d > 0.0) {
            double dist = Math.sqrt(dx * dx + dy * dy);
            dx /= d;
            dy /= d;
            d = dist / d;
            double ix = (double)x + 0.5;
            double iy = (double)y + 0.5;
            double dHeight = this.m_DEM.getCellValueAsDouble(x, y);
            double dHeight2 = this.m_DEM.getCellValueAsDouble(x2, y2);
            if (this.m_DEM.isNoDataValue(dHeight) || this.m_DEM.isNoDataValue(dHeight2)) {
                return;
            }
            double dAngle = Math.atan2((dHeight2 += this.m_dHeight2) - (dHeight += this.m_dHeight), dist * this.m_DEM.getWindowCellSize());
            straightlineSerie.add(0.0, dHeight);
            straightlineSerie.add(dist * this.m_DEM.getWindowCellSize(), dHeight2);
            fresnelSerie.add(0.0, dHeight);
            for (double id = 0.0; id < dist; id += d) {
                double dDist2;
                x = (int)(ix += dx);
                y = (int)(iy += dy);
                double z = this.m_DEM.getCellValueAsDouble(x, y);
                if (this.m_DEM.isNoDataValue(z)) continue;
                serie.add(id * this.m_DEM.getWindowCellSize(), z);
                double dDist = id * this.m_DEM.getWindowCellSize() / Math.cos(dAngle);
                Point2D pt = this.getFresnelZone(dDist, dDist2 = (dist - id) * this.m_DEM.getWindowCellSize() / Math.cos(dAngle), dAngle, dHeight);
                if (Double.isNaN(pt.getX()) || Double.isNaN(pt.getY())) continue;
                fresnelSerie.add(pt.getX(), pt.getY());
            }
            fresnelSerie.add(dist * this.m_DEM.getWindowCellSize(), dHeight2);
            JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.m_Dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
            ChartPanel jPanelChart = new ChartPanel(chart);
            jPanelChart.setPreferredSize(new Dimension(500, 300));
            jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.addOutputChart(GRAPH, Sextante.getText((String)"Line_of_sight"), jPanelChart);
        }
    }

    private Point2D getFresnelZone(double dDist, double dDist2, double dAngle, double dHeight) {
        double dRadius = Math.sqrt(this.m_dFrequency * (dDist * dDist2) / (dDist + dDist2));
        double y = dHeight + dDist * Math.sin(dAngle);
        double x = dDist * Math.cos(dAngle);
        System.out.println(dRadius);
        return new Point2D.Double(x += dRadius * Math.sin(dAngle), y -= dRadius * Math.cos(dAngle));
    }
}

