/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.hillshade;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class HillshadeAlgorithm
extends GeoAlgorithm {
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String AZIMUTH = "AZIMUTH";
    public static final String DECLINATION = "DECLINATION";
    public static final String EXAGGERATION = "EXAGGERATION";
    public static final String SHADED = "SHADED";
    public static final int METHOD_STANDARD = 0;
    public static final int METHOD_STANDARD_MAX_90 = 1;
    public static final int METHOD_COMBINED = 2;
    public static final int METHOD_RAY_TRACE = 3;
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double DEG_90_IN_RAD = 1.5707963267948966;
    private static final double DEG_180_IN_RAD = Math.PI;
    private double m_dExaggeration;
    private IRasterLayer m_Hillshade;
    private IRasterLayer m_Window = null;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Hillshade = this.getNewRasterLayer(SHADED, Sextante.getText((String)"Shaded_relief"), 4);
        double dAzimuth = this.m_Parameters.getParameterValueAsDouble(AZIMUTH) * (Math.PI / 180);
        double dDeclination = this.m_Parameters.getParameterValueAsDouble(DECLINATION) * (Math.PI / 180);
        this.m_dExaggeration = this.m_Parameters.getParameterValueAsDouble(EXAGGERATION);
        AnalysisExtent extent = this.m_Hillshade.getWindowGridExtent();
        this.m_Window.setWindowExtent(extent);
        switch (iMethod) {
            case 0: {
                this.getShading(dAzimuth, dDeclination, false, false);
                break;
            }
            case 1: {
                this.getShading(dAzimuth, dDeclination, true, false);
                break;
            }
            case 2: {
                this.getShading(dAzimuth, dDeclination, false, true);
                break;
            }
            case 3: {
                this.rayTrace(dAzimuth, dDeclination);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Standard"), Sextante.getText((String)"Standard_max_90\u00b0"), Sextante.getText((String)"Combined"), "Ray tracing"};
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
        this.setName(Sextante.getText((String)"Shaded_relief"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.m_Parameters.addNumericalValue(DECLINATION, Sextante.getText((String)"Sun_elevation_angle_[degrees]"), 45.0, 2);
            this.m_Parameters.addNumericalValue(AZIMUTH, Sextante.getText((String)"Sun_azimuthal_angle_[degrees]"), 315.0, 2);
            this.m_Parameters.addNumericalValue(EXAGGERATION, Sextante.getText((String)"Exaggeration"), 1.0, 2);
            this.addOutputRasterLayer(SHADED, Sextante.getText((String)"Shaded_relief"));
        }
        catch (RepeatedParameterNameException e) {
            e.printStackTrace();
        }
    }

    private void getShading(double dAzimuth, double dDeclination, boolean bDelimit, boolean bCombine) {
        int iNX = this.m_Window.getNX();
        int iNY = this.m_Window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                double dSlope = this.m_Window.getSlope(x, y);
                double dAspect = this.m_Window.getAspect(x, y);
                if (!this.m_Window.isNoDataValue(dSlope) && !this.m_Window.isNoDataValue(dAspect)) {
                    double dSinDec = Math.sin(dDeclination);
                    double dCosDec = Math.cos(dDeclination);
                    dSlope = Math.tan(dSlope);
                    double dShading = 1.5707963267948966 - Math.atan(this.m_dExaggeration * dSlope);
                    dShading = Math.acos(Math.sin(dShading) * dSinDec + Math.cos(dShading) * dCosDec * Math.cos(dAspect - dAzimuth));
                    if (bDelimit && dShading > 1.5707963267948966) {
                        dShading = 1.5707963267948966;
                    }
                    if (bCombine) {
                        dShading *= dSlope / 1.5707963267948966;
                    }
                    this.m_Hillshade.setCellValue(x, y, dShading);
                    continue;
                }
                this.m_Hillshade.setNoData(x, y);
            }
        }
    }

    private void rayTrace(double dAzimuth, double dDeclination) {
        int yStep;
        int yStart;
        int xStep;
        int xStart;
        int iNX = this.m_Window.getNX();
        int iNY = this.m_Window.getNY();
        this.getShading(dAzimuth, dDeclination, true, false);
        dAzimuth += Math.PI;
        if (Math.sin(dAzimuth) > 0.0) {
            xStart = 0;
            xStep = 1;
        } else {
            xStart = iNX - 1;
            xStep = -1;
        }
        if (Math.cos(dAzimuth) > 0.0) {
            yStart = 0;
            yStep = 1;
        } else {
            yStart = iNY - 1;
            yStep = -1;
        }
        double dx = Math.sin(dAzimuth);
        double dy = Math.cos(dAzimuth);
        if (Math.abs(dx) > Math.abs(dy)) {
            dy /= Math.abs(dx);
            dx = dx < 0.0 ? -1.0 : 1.0;
        } else if (Math.abs(dy) > Math.abs(dx)) {
            dx /= Math.abs(dy);
            dy = dy < 0.0 ? -1.0 : 1.0;
        } else {
            dx = dx < 0.0 ? -1.0 : 1.0;
            dy = dy < 0.0 ? -1.0 : 1.0;
        }
        double dz = Math.tan(dDeclination) * Math.sqrt(dx * dx + dy * dy) * this.m_Window.getWindowCellSize();
        int iy = 0;
        int y = yStart;
        while (iy < iNY && this.setProgress(iy, iNY)) {
            int ix = 0;
            int x = xStart;
            while (ix < iNX) {
                this.rayTrace_Trace(x, y, dx, dy, dz);
                ++ix;
                x += xStep;
            }
            ++iy;
            y += yStep;
        }
    }

    private void rayTrace_Trace(int x, int y, double dx, double dy, double dz) {
        double iz = this.m_Window.getCellValueAsDouble(x, y);
        if (!this.m_Window.isNoDataValue(iz)) {
            double ix = (double)x + 0.5;
            double iy = (double)y + 0.5;
            iz = this.m_Window.getCellValueAsDouble(x, y);
            while (true) {
                x = (int)(ix += dx);
                y = (int)(iy += dy);
                double iz2 = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(iz -= dz) || iz2 > iz) break;
                if (this.m_Window.isNoDataValue(iz)) continue;
                this.m_Hillshade.setCellValue(x, y, 1.5707963267948966);
            }
        }
    }
}

