/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.horizonBlockage;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HorizonBlockageAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String POINT = "POINT";
    public static final String HEIGHT = "HEIGHT";
    public static final String RADIUS = "RADIUS";
    public static final String RESULT = "RESULT";
    public static final String GRAPHSLOPE = "GRAPHSLOPE";
    public static final String GRAPHDIST = "GRAPHDIST";
    private int m_iNX;
    private int m_iNY;
    private IRasterLayer m_DEM = null;
    private GridCell m_Point;
    private double m_dHeight;
    private int m_iRadius;
    private IVectorLayer m_Horizon;
    private HorizonData[] m_HorizonData;
    private double m_dLineLength;

    public boolean processAlgorithm() {
        try {
            this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
            Point2D pt = this.m_Parameters.getParameterValueAsPoint(POINT);
            this.m_dHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHT);
            AnalysisExtent gridExtent = new AnalysisExtent((ILayer)this.m_DEM);
            this.m_DEM.setFullExtent();
            this.m_Horizon = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Horizon"), 1, new Class[]{Integer.class}, new String[]{"ID"});
            this.m_iRadius = (int)((double)this.m_Parameters.getParameterValueAsInt(RADIUS) / gridExtent.getCellSize());
            if (this.m_iRadius <= 0) {
                this.m_iRadius = Integer.MAX_VALUE;
            }
            this.m_iNX = this.m_DEM.getNX();
            this.m_iNY = this.m_DEM.getNY();
            this.m_Point = gridExtent.getGridCoordsFromWorldCoords(pt);
            this.m_dLineLength = Math.sqrt(this.m_iNX * this.m_iNX + this.m_iNY * this.m_iNY);
            this.calculateHorizon();
            this.createResults();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Horizon_blockage"));
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"Coordinates_of_emitter-receiver"));
            this.m_Parameters.addNumericalValue(HEIGHT, Sextante.getText((String)"Height_of_emitter-receiver"), 10.0, 2);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 0.0, 2);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Horizon"), 1);
            this.addOutputChart(GRAPHSLOPE, Sextante.getText((String)"Angle"));
            this.addOutputChart(GRAPHDIST, Sextante.getText((String)"Distance"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateHorizon() {
        this.m_HorizonData = new HorizonData[360];
        for (int i = 0; i < 360; ++i) {
            GridCell cell = this.getCellAtAngle(Math.toRadians(i));
            this.m_HorizonData[i] = this.calculateHorizonData(cell);
        }
    }

    private GridCell getCellAtAngle(double dAngle) {
        int x = (int)((double)this.m_Point.getX() + this.m_dLineLength * Math.sin(dAngle));
        int y = (int)((double)this.m_Point.getY() + this.m_dLineLength * Math.cos(dAngle));
        return new GridCell(x, y, 0.0);
    }

    private HorizonData calculateHorizonData(GridCell cell) {
        double d;
        double dx = cell.getX() - this.m_Point.getX();
        double dy = cell.getY() - this.m_Point.getY();
        double dMaxDist = 0.0;
        int iMaxX = 0;
        int iMaxY = 0;
        double dMaxSlope = Double.NEGATIVE_INFINITY;
        double z = this.m_DEM.getCellValueAsDouble(this.m_Point.getX(), this.m_Point.getY()) + this.m_dHeight;
        double d2 = d = Math.abs(dx) > Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        if (d > 0.0) {
            double dist = Math.sqrt(dx * dx + dy * dy);
            dx /= d;
            dy /= d;
            d = dist / d;
            double id = 0.0;
            double ix = (double)this.m_Point.getX() + 0.5;
            double iy = (double)this.m_Point.getY() + 0.5;
            while (id < dist) {
                int x = (int)(ix += dx);
                int y = (int)(iy += dy);
                if (!this.m_DEM.getWindowGridExtent().containsCell(x, y) || (id += d) > (double)this.m_iRadius) break;
                double dSlope = (this.m_DEM.getCellValueAsDouble(x, y) - z) / id;
                if (!(dSlope > dMaxSlope)) continue;
                dMaxSlope = dSlope;
                dMaxDist = id;
                iMaxX = x;
                iMaxY = y;
            }
        }
        return new HorizonData(dMaxSlope, dMaxDist, iMaxX, iMaxY);
    }

    private void createResults() {
        boolean bFirstPoint = true;
        XYSeriesCollection datasetSlope = new XYSeriesCollection();
        XYSeries serieSlope = new XYSeries((Comparable)((Object)Sextante.getText((String)"Angle")));
        datasetSlope.addSeries(serieSlope);
        XYSeriesCollection datasetDist = new XYSeriesCollection();
        XYSeries serieDist = new XYSeries((Comparable)((Object)Sextante.getText((String)"Distance")));
        datasetDist.addSeries(serieDist);
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < this.m_HorizonData.length; ++i) {
            double dAngle = Math.toDegrees(Math.atan(this.m_HorizonData[i].dAngle));
            serieDist.add((double)i, this.m_HorizonData[i].dDistance);
            serieSlope.add((double)i, dAngle);
            double x = this.m_HorizonData[i].x;
            double y = this.m_HorizonData[i].y;
            if (x == 0.0 && y == 0.0) continue;
            Point2D pt = this.m_DEM.getWindowGridExtent().getWorldCoordsFromGridCoords(new GridCell((int)x, (int)y, 0.0));
            x = pt.getX();
            y = pt.getY();
            coordinates.add(new Coordinate(x, y));
        }
        JFreeChart chartSlope = ChartFactory.createXYLineChart(null, null, null, (XYDataset)datasetSlope, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel jPanelChartSlope = new ChartPanel(chartSlope);
        jPanelChartSlope.setPreferredSize(new Dimension(500, 300));
        jPanelChartSlope.setPreferredSize(new Dimension(500, 300));
        jPanelChartSlope.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.addOutputChart(GRAPHSLOPE, Sextante.getText((String)"Angle"), jPanelChartSlope);
        JFreeChart chartDist = ChartFactory.createXYLineChart(null, null, null, (XYDataset)datasetDist, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel jPanelChartDist = new ChartPanel(chartDist);
        jPanelChartDist.setPreferredSize(new Dimension(500, 300));
        jPanelChartDist.setPreferredSize(new Dimension(500, 300));
        jPanelChartDist.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.addOutputChart(GRAPHDIST, Sextante.getText((String)"Distance"), jPanelChartDist);
        Object[] value = new Object[]{new Integer(1)};
        Coordinate[] coords = new Coordinate[coordinates.size()];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = (Coordinate)coordinates.get(i);
        }
        this.m_Horizon.addFeature((Geometry)new GeometryFactory().createLineString(coords), value);
    }

    private class HorizonData {
        public int x;
        public int y;
        public double dAngle = 0.0;
        public double dDistance = 0.0;

        HorizonData(double dA, double dD, int iX, int iY) {
            this.dAngle = dA;
            this.dDistance = dD;
            this.x = iX;
            this.y = iY;
        }
    }
}

