/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.viewshed;

import com.vividsolutions.jts.geom.Coordinate;
import es.unex.sextante.lighting.viewshed.VisibilityPair;
import es.unex.sextante.lighting.viewshed.VisibilitySegment;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class EqualLengthVisibilitySegmentQueue
extends LinkedList<VisibilityPair> {
    private static final long serialVersionUID = 728269644204953666L;
    private final Deque<VisibilitySegment> m_firstROS;
    private final Deque<VisibilitySegment> m_secondROS;
    private final double m_cellSize;

    public EqualLengthVisibilitySegmentQueue(List<Coordinate> firstROS, List<Coordinate> secondROS, double cellSize) {
        this.m_cellSize = cellSize;
        this.m_firstROS = new VisibilitySegmentQueue(firstROS);
        this.m_secondROS = new VisibilitySegmentQueue(secondROS);
    }

    @Override
    public boolean isEmpty() {
        return this.m_firstROS.isEmpty() && this.m_secondROS.isEmpty();
    }

    @Override
    public VisibilityPair poll() {
        Deque<VisibilitySegment> longSegmentQueue;
        VisibilitySegment longSegment;
        double lengthRatio;
        boolean isFirstROSShorter;
        double secondSegmentLength;
        VisibilitySegment firstROSSegment = this.m_firstROS.poll();
        VisibilitySegment secondROSSegment = this.m_secondROS.poll();
        if (firstROSSegment == null || secondROSSegment == null) {
            return new VisibilityPair(firstROSSegment, secondROSSegment);
        }
        double firstSegmentLength = firstROSSegment.getLength();
        double segmentComparison = firstSegmentLength - (secondSegmentLength = secondROSSegment.getLength());
        if (Math.abs(segmentComparison) < this.m_cellSize || this.m_firstROS.isEmpty() && this.m_secondROS.isEmpty()) {
            return new VisibilityPair(firstROSSegment, secondROSSegment);
        }
        if (segmentComparison < 0.0) {
            isFirstROSShorter = true;
            lengthRatio = firstSegmentLength / secondSegmentLength;
            longSegment = secondROSSegment;
            longSegmentQueue = this.m_secondROS;
        } else {
            isFirstROSShorter = false;
            lengthRatio = secondSegmentLength / firstSegmentLength;
            longSegment = firstROSSegment;
            longSegmentQueue = this.m_firstROS;
        }
        Coordinate dividingPoint = longSegment.pointAlong(lengthRatio);
        VisibilitySegment longSegmentFirstPart = new VisibilitySegment(longSegment.p0, dividingPoint, longSegment.getVisibility());
        VisibilitySegment longSegmentSecondPart = new VisibilitySegment(dividingPoint, longSegment.p1, longSegment.getVisibility());
        longSegmentQueue.push(longSegmentSecondPart);
        if (isFirstROSShorter) {
            return new VisibilityPair(firstROSSegment, longSegmentFirstPart);
        }
        return new VisibilityPair(longSegmentFirstPart, secondROSSegment);
    }

    private class VisibilitySegmentQueue
    extends LinkedList<VisibilitySegment> {
        private static final long serialVersionUID = 6999971040518772075L;
        private final Iterator<Coordinate> m_inputPoints;
        private final Deque<VisibilitySegment> m_addedSegments = new LinkedList<VisibilitySegment>();
        private Coordinate m_startPoint;

        public VisibilitySegmentQueue(List<Coordinate> input) {
            this.m_inputPoints = input.iterator();
            this.m_startPoint = this.m_inputPoints.next();
        }

        @Override
        public boolean isEmpty() {
            return this.m_addedSegments.isEmpty() && !this.m_inputPoints.hasNext();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void push(VisibilitySegment segment) {
            this.m_addedSegments.push(segment);
        }

        @Override
        public VisibilitySegment poll() {
            Coordinate nextPoint;
            if (!this.m_addedSegments.isEmpty()) {
                VisibilitySegment segment = this.m_addedSegments.poll();
                return segment;
            }
            if (!this.m_inputPoints.hasNext()) {
                return null;
            }
            do {
                nextPoint = this.m_inputPoints.next();
            } while (this.m_inputPoints.hasNext() && nextPoint.z == this.m_startPoint.z);
            Coordinate[] lineSegmentCoords = new Coordinate[]{this.m_startPoint, nextPoint};
            int segmentVisibility = (int)this.m_startPoint.z;
            this.m_startPoint = nextPoint;
            return new VisibilitySegment(lineSegmentCoords[0], lineSegmentCoords[1], segmentVisibility);
        }
    }
}

