/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.lighting.viewshed;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.lighting.viewshed.RangeOfSight;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;

public class R2ViewshedAlgorithm
extends GeoAlgorithm {
    public static final String DEM = "DEM";
    public static final String POINT = "POINT";
    public static final String HEIGHT = "HEIGHT";
    public static final String HEIGHTOBS = "HEIGHTOBS";
    public static final String RADIUS = "RADIUS";
    public static final String RESULT = "RESULT";
    private int m_xCellCount;
    private int m_yCellCount;
    private IRasterLayer m_DEM = null;
    private IRasterLayer m_visibilityRaster;
    private GridCell m_watcherCellPoint;
    private double m_watcherHeight;
    private double m_objectsHeight;
    private int m_searchRadius;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"R2_Viewshed"));
        this.setGroup(Sextante.getText((String)"Visibility_and_lighting"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"Coordinates_of_emitter-receiver"));
            this.m_Parameters.addNumericalValue(HEIGHT, Sextante.getText((String)"Height_of_emitter-receiver"), 10.0, 2);
            this.m_Parameters.addNumericalValue(HEIGHTOBS, Sextante.getText((String)"Height_of_mobile_receiver-emitter"), 0.0, 2);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 0.0, 2);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Viewshed_output"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_watcherHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHT);
        this.m_objectsHeight = this.m_Parameters.getParameterValueAsDouble(HEIGHTOBS);
        double worldSearchRadius = this.m_Parameters.getParameterValueAsDouble(RADIUS);
        this.m_searchRadius = (int)(worldSearchRadius / this.m_DEM.getLayerCellSize());
        Point2D watcherPoint = this.m_Parameters.getParameterValueAsPoint(POINT);
        this.m_AnalysisExtent = new AnalysisExtent((ILayer)this.m_DEM);
        if (this.m_searchRadius > 0) {
            double outputXMin = Math.max(watcherPoint.getX() - worldSearchRadius, this.m_AnalysisExtent.getXMin());
            double outputXMax = Math.min(watcherPoint.getX() + worldSearchRadius, this.m_AnalysisExtent.getXMax());
            double outputYMin = Math.max(watcherPoint.getY() - worldSearchRadius, this.m_AnalysisExtent.getYMin());
            double outputYMax = Math.min(watcherPoint.getY() + worldSearchRadius, this.m_AnalysisExtent.getYMax());
            this.m_AnalysisExtent.setXRange(outputXMin, outputXMax, true);
            this.m_AnalysisExtent.setYRange(outputYMin, outputYMax, true);
            this.m_AnalysisExtent.enlargeOneCell();
        }
        this.m_DEM.setWindowExtent(this.m_AnalysisExtent);
        this.m_visibilityRaster = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Viewshed_output"), 4);
        this.m_xCellCount = this.m_DEM.getNX();
        this.m_yCellCount = this.m_DEM.getNY();
        this.m_watcherCellPoint = this.m_DEM.getWindowGridExtent().getGridCoordsFromWorldCoords(watcherPoint);
        this.calculateVisibility(this.m_watcherCellPoint.getX(), this.m_watcherCellPoint.getY());
        return !this.m_Task.isCanceled();
    }

    private void calculateVisibility(int x_Pos, int y_Pos) {
        int yIndex;
        int xIndex;
        int iYMax;
        int iXMax;
        int iYMin;
        int iXMin;
        double watcherZValue = this.m_DEM.getCellValueAsDouble(x_Pos, y_Pos);
        if (this.m_DEM.isNoDataValue(watcherZValue)) {
            return;
        }
        this.m_watcherCellPoint.setValue(watcherZValue + this.m_watcherHeight);
        RangeOfSight rangeOfSight = new RangeOfSight(this.m_DEM, this.m_objectsHeight);
        if (this.m_searchRadius > 0) {
            iXMin = Math.max(0, x_Pos - this.m_searchRadius);
            iYMin = Math.max(0, y_Pos - this.m_searchRadius);
            iXMax = Math.min(this.m_xCellCount, x_Pos + this.m_searchRadius);
            iYMax = Math.min(this.m_xCellCount, y_Pos + this.m_searchRadius);
        } else {
            iXMin = 0;
            iXMax = this.m_xCellCount;
            iYMin = 0;
            iYMax = this.m_yCellCount;
        }
        ArrayList<GridCell> edgeCells = new ArrayList<GridCell>();
        for (xIndex = iXMin; xIndex < iXMax; ++xIndex) {
            edgeCells.add(new GridCell(xIndex, iYMin, 0.0));
        }
        for (yIndex = iYMin + 1; yIndex < iYMax; ++yIndex) {
            edgeCells.add(new GridCell(iXMax - 1, yIndex, 0.0));
        }
        for (xIndex = iXMax - 2; xIndex >= iXMin; --xIndex) {
            edgeCells.add(new GridCell(xIndex, iYMax - 1, 0.0));
        }
        for (yIndex = iYMax - 2; yIndex >= iYMin + 1; --yIndex) {
            edgeCells.add(new GridCell(iXMin, yIndex, 0.0));
        }
        int cellIndex = 0;
        for (GridCell edgeCell : edgeCells) {
            this.setProgress(cellIndex++, edgeCells.size());
            LinkedList<GridCell> ros = rangeOfSight.Calculate(this.m_watcherCellPoint, edgeCell, false);
            for (GridCell visibilityCell : ros) {
                if (Math.pow(visibilityCell.getX() - this.m_watcherCellPoint.getX(), 2.0) + Math.pow(visibilityCell.getY() - this.m_watcherCellPoint.getY(), 2.0) > Math.pow(this.m_searchRadius, 2.0)) {
                    this.m_visibilityRaster.setCellValue(visibilityCell.getX(), visibilityCell.getY(), this.m_visibilityRaster.getNoDataValue());
                    continue;
                }
                this.m_visibilityRaster.setCellValue(visibilityCell.getX(), visibilityCell.getY(), visibilityCell.getValue());
            }
        }
    }
}

