/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.anisotropicCoefficientOfVariation;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;

public class ACVAlgorithm
extends GeoAlgorithm {
    private double NO_DATA;
    public static final String DEM = "DEM";
    public static final String RESULT = "RESULT";
    IRasterLayer m_ACV;
    IRasterLayer m_DEM;
    IRasterLayer m_DX;
    IRasterLayer m_DY;
    IRasterLayer m_DUp;
    IRasterLayer m_DDown;
    int m_iNX;
    int m_iNY;
    int m_iSize = 5;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.NO_DATA = this.m_OutputFactory.getDefaultNoDataValue();
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_ACV = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Anisotropic_coefficient_of_variation"), 4);
        AnalysisExtent extent = this.m_ACV.getWindowGridExtent();
        this.m_DX = this.getTempRasterLayer(4, extent);
        this.m_DY = this.getTempRasterLayer(4, extent);
        this.m_DDown = this.getTempRasterLayer(4, extent);
        this.m_DUp = this.getTempRasterLayer(4, extent);
        this.m_DEM.setWindowExtent(extent);
        this.m_iNX = this.m_DEM.getNX();
        this.m_iNY = this.m_DEM.getNY();
        this.m_ACV.setNoDataValue(this.NO_DATA);
        this.calculateDerivatives();
        this.setProgressText(Sextante.getText((String)"Calculating_coefficient") + "...");
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.m_ACV.setCellValue(x, y, this.getACV(x, y));
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setName(Sextante.getText((String)"Anisotropic_coefficient_of_variation"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Anisotropic_coefficient_of_variation"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void calculateDerivatives() throws UnsupportedOutputChannelException {
        this.setProgressText(Sextante.getText((String)"Calculating_derivatives") + "...");
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                this.m_DX.setCellValue(x, y, this.getDFDX(x, y));
                this.m_DY.setCellValue(x, y, this.getDFDY(x, y));
                this.m_DDown.setCellValue(x, y, this.getDFDDown(x, y));
                this.m_DUp.setCellValue(x, y, this.getDFDUp(x, y));
            }
        }
        this.smooth(this.m_DX);
        this.smooth(this.m_DY);
        this.smooth(this.m_DDown);
        this.smooth(this.m_DUp);
    }

    private void smooth(IRasterLayer driver) throws UnsupportedOutputChannelException {
        IRasterLayer temp = this.getTempRasterLayer(4, this.m_DEM.getWindowGridExtent());
        for (int y = 1; y < this.m_iNY - 1; ++y) {
            for (int x = 1; x < this.m_iNX - 1; ++x) {
                double dSum = 0.0;
                int iValidCells = 0;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        double dValue = driver.getCellValueAsDouble(x + i, y + j);
                        if (dValue == this.NO_DATA) continue;
                        dSum += dValue;
                        ++iValidCells;
                    }
                }
                if (iValidCells != 0) {
                    temp.setCellValue(x, y, dSum / (double)iValidCells);
                    continue;
                }
                temp.setNoData(x, y);
            }
        }
        driver = temp;
        System.gc();
    }

    private double getACV(int x, int y) {
        double dX = this.m_DX.getCellValueAsDouble(x, y);
        double dY = this.m_DY.getCellValueAsDouble(x, y);
        double dUp = this.m_DUp.getCellValueAsDouble(x, y);
        double dDown = this.m_DDown.getCellValueAsDouble(x, y);
        if (dX == this.NO_DATA || dY == this.NO_DATA || dUp == this.NO_DATA || dDown == this.NO_DATA) {
            return this.NO_DATA;
        }
        double dAvg = (dX + dY + dUp + dDown) / 4.0;
        double dDif = 0.0;
        double dZ = this.m_DX.getCellValueAsDouble(x, y - 1);
        if (dZ != this.NO_DATA) {
            dDif += Math.pow(dAvg - dZ, 2.0);
        } else {
            return this.NO_DATA;
        }
        dZ = this.m_DX.getCellValueAsDouble(x, y + 1);
        if (dZ != this.NO_DATA) {
            dDif += Math.pow(dAvg - dZ, 2.0);
        } else {
            return this.NO_DATA;
        }
        dZ = this.m_DY.getCellValueAsDouble(x - 1, y);
        if (dZ != this.NO_DATA) {
            dDif += Math.pow(dAvg - dZ, 2.0);
        } else {
            return this.NO_DATA;
        }
        dZ = this.m_DY.getCellValueAsDouble(x + 1, y);
        if (dZ != this.NO_DATA) {
            dDif += Math.pow(dAvg - dZ, 2.0);
        } else {
            return this.NO_DATA;
        }
        dZ = this.m_DDown.getCellValueAsDouble(x - 1, y + 1);
        if (dZ != this.NO_DATA) {
            dDif += Math.pow(dAvg - dZ, 2.0);
        } else {
            return this.NO_DATA;
        }
        dZ = this.m_DDown.getCellValueAsDouble(x + 1, y - 1);
        if (dZ != this.NO_DATA) {
            dDif += Math.pow(dAvg - dZ, 2.0);
        } else {
            return this.NO_DATA;
        }
        dZ = this.m_DUp.getCellValueAsDouble(x - 1, y - 1);
        if (dZ != this.NO_DATA) {
            dDif += Math.pow(dAvg - dZ, 2.0);
        } else {
            return this.NO_DATA;
        }
        dZ = this.m_DUp.getCellValueAsDouble(x + 1, y + 1);
        if (dZ == this.NO_DATA) {
            return this.NO_DATA;
        }
        return Math.log(1.0 + Math.sqrt((dDif += Math.pow(dAvg - dZ, 2.0)) / 8.0) / dAvg);
    }

    private double getDFDX(int x, int y) {
        double[] dValues = new double[4];
        double dValue = this.m_DEM.getCellValueAsDouble(x - 2, y);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[0] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x - 1, y);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[1] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x + 1, y);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[2] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x + 2, y);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[3] = dValue;
        return Math.abs(dValues[0] + dValues[1] * -8.0 + dValues[2] * 8.0 + dValues[3] * -1.0);
    }

    private double getDFDY(int x, int y) {
        double[] dValues = new double[4];
        double dValue = this.m_DEM.getCellValueAsDouble(x, y - 2);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[0] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x, y - 1);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[1] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x, y + 1);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[2] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x, y + 2);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[3] = dValue;
        return Math.abs(dValues[0] + dValues[1] * -8.0 + dValues[2] * 8.0 + dValues[3] * -1.0);
    }

    private double getDFDDown(int x, int y) {
        double[] dValues = new double[4];
        double dValue = this.m_DEM.getCellValueAsDouble(x - 2, y + 2);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[0] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x - 1, y + 1);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[1] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x + 1, y - 1);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[2] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x + 2, y - 2);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[3] = dValue;
        return Math.abs(dValues[0] + dValues[1] * -8.0 + dValues[2] * 8.0 + dValues[3] * -1.0);
    }

    private double getDFDUp(int x, int y) {
        double[] dValues = new double[4];
        double dValue = this.m_DEM.getCellValueAsDouble(x - 2, y - 2);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[0] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x - 1, y - 1);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[1] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x + 1, y + 1);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[2] = dValue;
        dValue = this.m_DEM.getCellValueAsDouble(x + 2, y + 2);
        if (this.m_DEM.isNoDataValue(dValue)) {
            return this.NO_DATA;
        }
        dValues[3] = dValue;
        return Math.abs(dValues[0] + dValues[1] * -8.0 + dValues[2] * 8.0 + dValues[3] * -1.0);
    }
}

