/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.convergence;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ConvergenceAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String METHOD = "METHOD";
    public static final String RESULT = "RESULT";
    private static final double DEG_45_IN_RAD = Math.toRadians(45.0);
    private static final double DEG_90_IN_RAD = Math.toRadians(90.0);
    private static final double DEG_180_IN_RAD = Math.toRadians(180.0);
    private static final double DEG_360_IN_RAD = Math.toRadians(360.0);
    IRasterLayer m_Convergence;
    IRasterLayer m_DEM;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_Convergence = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Convergence"), 4);
        AnalysisExtent extent = this.m_Convergence.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        int iNX = this.m_DEM.getNX();
        int iNY = this.m_DEM.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            block5: for (int x = 0; x < iNX; ++x) {
                switch (iMethod) {
                    case 0: {
                        this.Do_Aspect(x, y);
                        continue block5;
                    }
                    case 1: {
                        this.Do_Gradient(x, y);
                    }
                }
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Aspect"), Sextante.getText((String)"Gradient")};
        this.setName(Sextante.getText((String)"Convergence_index"));
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Convergence"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void Do_Aspect(int x, int y) {
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_DEM.isNoDataValue(z)) {
            this.m_Convergence.setNoData(x, y);
        } else {
            int i = 0;
            int n = 0;
            double dSum = 0.0;
            double dIAspect = -DEG_180_IN_RAD;
            while (i < 8) {
                double dAspect;
                double z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                if (!this.m_DEM.isNoDataValue(z2) && !this.m_DEM.isNoDataValue(dAspect = this.m_DEM.getAspect(x + m_iOffsetX[i], y + m_iOffsetY[i])) && dAspect >= 0.0) {
                    double d = dAspect - dIAspect;
                    if ((d %= DEG_360_IN_RAD) < -DEG_180_IN_RAD) {
                        d += DEG_360_IN_RAD;
                    } else if (d > DEG_180_IN_RAD) {
                        d -= DEG_360_IN_RAD;
                    }
                    dSum += Math.abs(d);
                    ++n;
                }
                ++i;
                dIAspect += DEG_45_IN_RAD;
            }
            double res = dSum / (double)n;
            res -= DEG_90_IN_RAD;
            res = res * 100.0 / DEG_90_IN_RAD;
            this.m_Convergence.setCellValue(x, y, n > 0 ? (dSum / (double)n - DEG_90_IN_RAD) * 100.0 / DEG_90_IN_RAD : 0.0);
        }
    }

    private void Do_Gradient(int x, int y) {
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (this.m_DEM.isNoDataValue(z)) {
            this.m_Convergence.setNoData(x, y);
        } else {
            int i = 0;
            int n = 0;
            double dSum = 0.0;
            double dIAspect = -DEG_180_IN_RAD;
            while (i < 8) {
                double z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                if (!this.m_DEM.isNoDataValue(z2)) {
                    double dSlope = this.m_DEM.getSlope(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                    double dAspect = this.m_DEM.getAspect(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                    if (!this.m_DEM.isNoDataValue(dAspect) && dAspect >= 0.0) {
                        double dISlope = Math.atan((z2 - z) / this.m_DEM.getDistToNeighborInDir(i));
                        double d = Math.acos(Math.sin(dSlope) * Math.sin(dISlope) + Math.cos(dSlope) * Math.cos(dISlope) * Math.cos(dIAspect - dAspect));
                        if ((d %= DEG_360_IN_RAD) < -DEG_180_IN_RAD) {
                            d += DEG_360_IN_RAD;
                        } else if (d > DEG_180_IN_RAD) {
                            d -= DEG_360_IN_RAD;
                        }
                        dSum += Math.abs(d);
                        ++n;
                    }
                }
                ++i;
                dIAspect += DEG_45_IN_RAD;
            }
            this.m_Convergence.setCellValue(x, y, n > 0 ? (dSum / (double)n - DEG_90_IN_RAD) * 100.0 / DEG_90_IN_RAD : 0.0);
        }
    }
}

