/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.curvatures;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CurvaturesAlgorithm
extends GeoAlgorithm {
    private static final double PLAN_THRESHOLD = 1.0E-5;
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String METHOD = "METHOD";
    public static final String DEM = "DEM";
    public static final String HORZ = "HORZ";
    public static final String VERT = "VERT";
    public static final String GLOBAL = "GLOBAL";
    public static final String CLASS = "CLASS";
    IRasterLayer m_DEM = null;
    IRasterLayer m_Curv;
    IRasterLayer m_hCurv;
    IRasterLayer m_vCurv;
    IRasterLayer m_CurvClass;
    private double _6DX;
    private double _2DX;
    private double _4_DX2;
    private double _DX2;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_hCurv = this.getNewRasterLayer(HORZ, Sextante.getText((String)"Horizontal_curvature"), 4);
        this.m_vCurv = this.getNewRasterLayer(VERT, Sextante.getText((String)"Vertical_curvature"), 4);
        this.m_Curv = this.getNewRasterLayer(GLOBAL, Sextante.getText((String)"Curvature"), 4);
        this.m_CurvClass = this.getNewRasterLayer(CLASS, Sextante.getText((String)"Classification"), 2);
        AnalysisExtent extent = this.m_hCurv.getWindowGridExtent();
        this.m_DEM.setWindowExtent(extent);
        int iNX = this.m_DEM.getNX();
        int iNY = this.m_DEM.getNY();
        this._2DX = this.m_DEM.getWindowCellSize() * 2.0;
        this._DX2 = this.m_DEM.getWindowCellSize() * this.m_DEM.getWindowCellSize();
        this._4_DX2 = 4.0 * this.m_DEM.getWindowCellSize() * this.m_DEM.getWindowCellSize();
        this._6DX = this.m_DEM.getWindowCellSize() * 6.0;
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            block7: for (int x = 0; x < iNX; ++x) {
                switch (iMethod) {
                    case 0: {
                        this.Do_FD_BRM(x, y);
                        continue block7;
                    }
                    case 1: {
                        this.Do_FD_Heerdegen(x, y);
                        continue block7;
                    }
                    case 2: {
                        this.Do_FD_Zevenbergen(x, y);
                        continue block7;
                    }
                    case 3: {
                        this.Do_FD_Haralick(x, y);
                    }
                }
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Fit_2_Degree_Polynom__Bauer_Rohdenburg_Bork_1985"), Sextante.getText((String)"Fit_2_Degree_Polynom__Heerdegen_&_Beran_1982"), Sextante.getText((String)"Fit_2_Degree_Polynom__Zevenbergen_&_Thorne_1987"), Sextante.getText((String)"Fit_3_Degree_Polynom__Haralick_1983")};
        this.setName(Sextante.getText((String)"Curvatures"));
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sMethod);
            this.addOutputRasterLayer(HORZ, Sextante.getText((String)"Horizontal_curvature"));
            this.addOutputRasterLayer(VERT, Sextante.getText((String)"Vertical_curvature"));
            this.addOutputRasterLayer(GLOBAL, Sextante.getText((String)"Curvature"));
            this.addOutputRasterLayer(CLASS, Sextante.getText((String)"Classification"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void Do_FD_BRM(int x, int y) {
        double[] zm = new double[9];
        if (this.Get_SubMatrix3x3(x, y, zm)) {
            double D = (zm[0] + zm[2] + zm[3] + zm[5] + zm[6] + zm[8] - 2.0 * (zm[1] + zm[4] + zm[7])) / this._DX2;
            double E = (zm[0] + zm[6] + zm[1] + zm[7] + zm[2] + zm[8] - 2.0 * (zm[3] + zm[4] + zm[5])) / this._DX2;
            double F = (zm[8] + zm[0] - zm[7]) / this._4_DX2;
            double G = (zm[2] - zm[0] + (zm[5] - zm[3]) + (zm[8] - zm[6])) / this._6DX;
            double H = (zm[6] - zm[0] + (zm[7] - zm[1]) + (zm[8] - zm[2])) / this._6DX;
            this.Set_Parameters_Derive(x, y, D, E, F, G, H);
        }
    }

    private void Do_FD_Heerdegen(int x, int y) {
        double[] zm = new double[9];
        if (this.Get_SubMatrix3x3(x, y, zm)) {
            double a = zm[0] + zm[2] + zm[3] + zm[5] + zm[6] + zm[8];
            double b = zm[0] + zm[1] + zm[2] + zm[6] + zm[7] + zm[8];
            double D = (0.3 * a - 0.2 * b) / this._DX2;
            double E = (0.3 * b - 0.2 * a) / this._DX2;
            double F = (zm[0] - zm[2] - zm[6] + zm[8]) / this._4_DX2;
            double G = (-zm[0] + zm[2] - zm[3] + zm[5] - zm[6] + zm[8]) / this._6DX;
            double H = (-zm[0] - zm[1] - zm[2] + zm[6] + zm[7] + zm[8]) / this._6DX;
            this.Set_Parameters_Derive(x, y, D, E, F, G, H);
        }
    }

    private void Do_FD_Zevenbergen(int x, int y) {
        double[] zm = new double[9];
        if (this.Get_SubMatrix3x3(x, y, zm)) {
            double D = ((zm[3] + zm[5]) / 2.0 - zm[4]) / this._DX2;
            double E = ((zm[1] + zm[7]) / 2.0 - zm[4]) / this._DX2;
            double F = (zm[0] - zm[2] - zm[6] + zm[8]) / this._4_DX2;
            double G = (zm[5] - zm[3]) / this._2DX;
            double H = (zm[7] - zm[1]) / this._2DX;
            this.Set_Parameters_Derive(x, y, D, E, F, G, H);
        }
    }

    private void Do_FD_Haralick(int x, int y) {
        int[][][] Mtrx = new int[][][]{new int[][]{{31, -5, -17, -5, 31}, {-44, -62, -68, -62, -44}, {0, 0, 0, 0, 0}, {44, 62, 68, 62, 44}, {-31, 5, 17, 5, -31}}, new int[][]{{31, -44, 0, 44, -31}, {-5, -62, 0, 62, 5}, {-17, -68, 0, 68, 17}, {-5, -62, 0, 62, 5}, {31, -44, 0, 44, -31}}, new int[][]{{2, 2, 2, 2, 2}, {-1, -1, -1, -1, -1}, {-2, -2, -2, -2, -2}, {-1, -1, -1, -1, -1}, {2, 2, 2, 2, 2}}, new int[][]{{4, 2, 0, -2, -4}, {2, 1, 0, -1, -2}, {0, 0, 0, 0, 0}, {-2, -1, 0, 1, 2}, {-4, -2, 0, 2, 4}}, new int[][]{{2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}, {2, -1, -2, -1, 2}}};
        int[] QMtrx = new int[]{4200, 4200, 700, 1000, 700};
        double[] zm = new double[25];
        double[] k = new double[5];
        if (this.Get_SubMatrix5x5(x, y, zm)) {
            for (int i = 0; i < 5; ++i) {
                int n = 0;
                double Sum = 0.0;
                for (int iy = 0; iy < 5; ++iy) {
                    int ix = 0;
                    while (ix < 5) {
                        Sum += zm[n] * (double)Mtrx[i][ix][iy];
                        ++ix;
                        ++n;
                    }
                }
                k[i] = Sum / (double)QMtrx[i];
            }
            this.Set_Parameters_Derive(x, y, k[4], k[2], k[3], k[1], k[0]);
        }
    }

    private void Set_Parameters(int x, int y, double dCurv, double dHCurv, double dVCurv) {
        int iClass;
        this.m_Curv.setCellValue(x, y, dCurv);
        this.m_hCurv.setCellValue(x, y, dHCurv);
        this.m_vCurv.setCellValue(x, y, dVCurv);
        int n = dHCurv < -1.0E-5 ? 0 : (iClass = dHCurv <= 1.0E-5 ? 3 : 6);
        this.m_CurvClass.setCellValue(x, y, (double)(iClass += dVCurv < -1.0E-5 ? 0 : (dVCurv <= 1.0E-5 ? 1 : 2)));
    }

    private void Set_Parameters_Derive(int x, int y, double D, double E, double F, double G, double H) {
        double hCurv;
        double vCurv;
        double Curv;
        double k1 = F * G * H;
        double k2 = G * G + H * H;
        if (k2 != 0.0) {
            Curv = -2.0 * (E + D);
            vCurv = -2.0 * (D * G * G + E * H * H + k1) / k2;
            hCurv = -2.0 * (D * H * H + E * G * G - k1) / k2;
        } else {
            hCurv = 0.0;
            vCurv = 0.0;
            Curv = 0.0;
        }
        this.Set_Parameters(x, y, Curv, hCurv, vCurv);
    }

    private void Set_Parameters_NoData(int x, int y) {
        this.m_Curv.setNoData(x, y);
        this.m_hCurv.setNoData(x, y);
        this.m_vCurv.setNoData(x, y);
    }

    private boolean Get_SubMatrix3x3(int x, int y, double[] SubMatrix) {
        int[] iSub = new int[]{5, 8, 7, 6, 3, 0, 1, 2};
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(z)) {
            SubMatrix[4] = 0.0;
            for (int i = 0; i < 8; ++i) {
                double z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
                SubMatrix[iSub[i]] = !this.m_DEM.isNoDataValue(z2) ? z2 - z : (!this.m_DEM.isNoDataValue(z2 = this.m_DEM.getCellValueAsDouble(x + m_iOffsetY[(i + 4) % 8], y + m_iOffsetY[(i + 4) % 8])) ? z - z2 : 0.0);
            }
            return true;
        }
        this.Set_Parameters_NoData(x, y);
        return false;
    }

    private boolean Get_SubMatrix5x5(int x, int y, double[] SubMatrix) {
        double z = this.m_DEM.getCellValueAsDouble(x, y);
        if (!this.m_DEM.isNoDataValue(z)) {
            int i = 0;
            for (int iy = y - 2; iy <= y + 2; ++iy) {
                int jy = iy < 0 ? 0 : (iy >= this.m_DEM.getNY() ? this.m_DEM.getNY() - 1 : iy);
                int ix = x - 2;
                while (ix <= x + 2) {
                    int jx = ix < 0 ? 0 : (ix >= this.m_DEM.getNX() ? this.m_DEM.getNY() - 1 : ix);
                    double z2 = this.m_DEM.getCellValueAsDouble(jx, jy);
                    SubMatrix[i] = !this.m_DEM.isNoDataValue(z2) ? z2 - z : 0.0;
                    ++ix;
                    ++i;
                }
            }
            return true;
        }
        return false;
    }
}

