/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.hypsometry;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class HypsometryAlgorithm
extends GeoAlgorithm {
    private static final int CLASS_COUNT = 100;
    public static final String DEM = "DEM";
    public static final String RESULT = "RESULT";
    IRasterLayer m_DEM = null;
    private double _DX2;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double z;
        int x;
        int y;
        double dMin = 0.0;
        double dMax = 0.0;
        String[] sFields = new String[]{Sextante.getText((String)"Relative_elevation"), Sextante.getText((String)"Relative_area"), Sextante.getText((String)"Absolute_elevation"), Sextante.getText((String)"Absolute_area")};
        Class[] iTypes = new Class[]{Double.class, Double.class, Double.class, Double.class};
        long[] Count = new long[101];
        Object[] values = new Object[4];
        this.m_DEM = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_DEM.setFullExtent();
        int iNX = this.m_DEM.getNX();
        int iNY = this.m_DEM.getNY();
        this._DX2 = this.m_DEM.getWindowCellSize() * this.m_DEM.getWindowCellSize();
        int A = 0;
        for (y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (x = 0; x < iNX; ++x) {
                z = this.m_DEM.getCellValueAsFloat(x, y);
                if (this.m_DEM.isNoDataValue(z)) continue;
                if (A <= 0) {
                    dMin = dMax = z;
                } else if (dMin > z) {
                    dMin = z;
                } else if (dMax < z) {
                    dMax = z;
                }
                ++A;
            }
        }
        if (A > 0 && dMin < dMax) {
            int i;
            for (y = 0; y < iNY; ++y) {
                for (x = 0; x < iNX; ++x) {
                    z = this.m_DEM.getCellValueAsFloat(x, y);
                    if (this.m_DEM.isNoDataValue(z)) continue;
                    int n = i = (int)(100.0 * (dMax - z) / (dMax - dMin));
                    Count[n] = Count[n] + 1L;
                }
            }
            double dDz = (dMax - dMin) / 100.0;
            int a = A;
            String sTableName = Sextante.getText((String)"Hypsometry_[") + this.m_DEM.getName() + "]";
            ITable table = this.getNewTable(RESULT, sTableName, iTypes, sFields);
            for (i = 100; i >= 0; --i) {
                double dZa = (double)a / (double)A;
                a = (int)((long)a - Count[i]);
                values[0] = new Double(100.0 * (double)i * dDz / (dMax - dMin));
                values[1] = new Double(100.0 * dZa);
                values[2] = new Double(dMin + (double)i * dDz);
                values[3] = new Double((double)a * this._DX2);
                table.addRecord(values);
            }
            return !this.m_Task.isCanceled();
        }
        return false;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Hypsometry"));
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.setUserCanDefineAnalysisExtent(false);
            this.addOutputTable(RESULT, Sextante.getText((String)"Hypsometry"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

