/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.morphometry.protectionIndex;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ProtectionIndexAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String DEM = "DEM";
    public static final String RADIUS = "RADIUS";
    public static final String RESULT = "RESULT";
    double m_dRadius;
    IRasterLayer m_ProtectionIndex;
    IRasterLayer m_Window = null;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        this.m_dRadius = this.m_Parameters.getParameterValueAsDouble(RADIUS);
        this.m_ProtectionIndex = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Protection_index"), 4);
        AnalysisExtent extent = this.m_ProtectionIndex.getWindowGridExtent();
        this.m_Window.setWindowExtent(extent);
        int iNX = this.m_Window.getNX();
        int iNY = this.m_Window.getNY();
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                this.setProtectionIndex(x, y);
            }
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Geomorphometry_and_terrain_analysis"));
        this.setName(Sextante.getText((String)"Protection_index"));
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radius"), 2, 1000.0, 0.0, Double.MAX_VALUE);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Protection_index"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void setProtectionIndex(int x, int y) {
        double dProtectionIndex = 0.0;
        double z = this.m_Window.getCellValueAsDouble(x, y);
        for (int i = 0; i < 8; ++i) {
            int j = 1;
            double dMaxAngle = 0.0;
            double dDist = this.m_Window.getDistToNeighborInDir(i) * (double)j;
            while (dDist < this.m_dRadius) {
                double z2 = this.m_Window.getCellValueAsDouble(x + m_iOffsetX[i] * j, y + m_iOffsetY[i] * j);
                if (this.m_Window.isNoDataValue(z2)) {
                    this.m_ProtectionIndex.setNoData(x, y);
                    return;
                }
                double dDifHeight = z2 - z;
                double dAngle = Math.atan(dDifHeight / dDist);
                if (dMaxAngle < dAngle) {
                    dMaxAngle = dAngle;
                }
                dDist = this.m_Window.getDistToNeighborInDir(i) * (double)(++j);
            }
            dProtectionIndex += dMaxAngle;
        }
        this.m_ProtectionIndex.setCellValue(x, y, dProtectionIndex / 8.0);
    }
}

