/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.nearestNeighbour;

import es.unex.sextante.closestpts.Point3D;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.rTree.SextanteRTree;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;

public class NNInterpolationAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String FIELD = "FIELD";
    public static final String RESULT = "RESULT";
    protected int m_iField;
    protected IVectorLayer m_Layer;
    private SextanteRTree m_SearchEngine;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Rasterization_and_interpolation"));
        this.setName(Sextante.getText((String)"Nearest_neighbour"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Point_layer"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LAYER);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        this.m_SearchEngine = new SextanteRTree(this.m_Layer, this.m_iField, this.m_Task);
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.m_Layer.getName() + Sextante.getText((String)"[interpolated]"), 5);
        int iNX = this.m_AnalysisExtent.getNX();
        int iNY = this.m_AnalysisExtent.getNY();
        this.setProgressText(Sextante.getText((String)"Interpolating"));
        for (int y = 0; y < iNY && this.setProgress(y, iNY); ++y) {
            for (int x = 0; x < iNX; ++x) {
                result.setCellValue(x, y, this.getValueAt(x, y));
            }
        }
        return !this.m_Task.isCanceled();
    }

    protected double getValueAt(int x, int y) {
        Point2D pt = this.m_AnalysisExtent.getWorldCoordsFromGridCoords(new GridCell(x, y, 0.0));
        Point3D closestPt = this.m_SearchEngine.getClosestPoint(pt.getX(), pt.getY());
        return closestPt.getZ();
    }
}

