/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.pointAnalysis.meanCenter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.shapesTools.ShapesTools;

public class MeanCenterAlgorithm
extends GeoAlgorithm {
    private static final int METHOD_WEIGHTED = 1;
    private static final int METHOD_NOT_WEIGHTED = 0;
    private static final String POINTS = "POINTS";
    private static final String FIELD = "FIELDS";
    private static final String METHOD = "METHOD";
    private static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dWeight;
        double y;
        double x;
        Coordinate coord;
        Geometry geom;
        IFeature feature;
        double dSumX = 0.0;
        double dSumY = 0.0;
        double dSumWeight = 0.0;
        double dDifDist = 0.0;
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int iCount = layer.getShapesCount();
        if (iCount == 0) {
            throw new GeoAlgorithmExecutionException("0 points in layer");
        }
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount * 2)) {
            feature = iter.next();
            geom = feature.getGeometry();
            coord = geom.getCoordinate();
            x = coord.x;
            y = coord.y;
            if (iMethod == 1) {
                try {
                    dWeight = Double.parseDouble(feature.getRecord().getValue(iField).toString());
                }
                catch (Exception e) {
                    dWeight = 1.0;
                }
            } else {
                dWeight = 1.0;
            }
            dSumWeight += dWeight;
            dSumX += dWeight * x;
            dSumY += dWeight * y;
            ++i;
        }
        iter.close();
        double xCenter = dSumX / dSumWeight;
        double yCenter = dSumY / dSumWeight;
        dSumWeight = 0.0;
        iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount * 2)) {
            feature = iter.next();
            geom = feature.getGeometry();
            coord = geom.getCoordinate();
            x = coord.x;
            y = coord.y;
            if (iMethod == 1) {
                try {
                    dWeight = Double.parseDouble(feature.getRecord().getValue(iField).toString());
                }
                catch (Exception e) {
                    dWeight = 1.0;
                }
            } else {
                dWeight = 1.0;
            }
            dSumWeight += dWeight;
            double dDifX = x - xCenter;
            double dDifY = y - yCenter;
            dDifDist += dDifX * dDifX * dWeight + dDifY * dDifY * dWeight;
            ++i;
        }
        iter.close();
        double dStdDist = Math.sqrt(dDifDist / dSumWeight);
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Standard_distance"), 2, new Class[]{Double.class}, new String[]{Sextante.getText((String)"Radius__standard_deviation")});
        Object[] value = new Object[]{new Double(dStdDist)};
        Geometry circle = ShapesTools.createCircle((double)xCenter, (double)yCenter, (double)dStdDist);
        output.addFeature(circle, value);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sOptions = new String[]{Sextante.getText((String)"Mean_center"), Sextante.getText((String)"Weighted_mean_center")};
        this.setName(Sextante.getText((String)"Mean_center_and_standard_distance"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Weights"), POINTS);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Method"), sOptions);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Mean_center_and_standard_distance"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

