/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.pointAnalysis.nearestNeighbour;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class NNAnalysisAlgorithm
extends GeoAlgorithm {
    private static final String RESULT = "RESULT";
    private static final String POINTS = "POINTS";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dSum = 0.0;
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Rectangle2D rect = layer.getFullExtent();
        double dArea = rect.getWidth() * rect.getHeight();
        double dPerimeter = 2.0 * rect.getWidth() + 2.0 * rect.getHeight();
        int iCount = layer.getShapesCount();
        int i = 0;
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            double x1 = coord.x;
            double y1 = coord.y;
            double dMin = Double.MAX_VALUE;
            int j = 0;
            IFeatureIterator iter2 = layer.iterator();
            while (iter2.hasNext()) {
                IFeature feature2 = iter2.next();
                if (i != j) {
                    Geometry geom2 = feature2.getGeometry();
                    Coordinate coord2 = geom2.getCoordinate();
                    double x2 = coord2.x;
                    double y2 = coord2.y;
                    double dDifX = x2 - x1;
                    double dDifY = y2 - y1;
                    dMin = Math.min(dMin, Math.sqrt(dDifX * dDifX + dDifY * dDifY));
                }
                ++j;
            }
            iter2.close();
            dSum += dMin;
            ++i;
        }
        iter.close();
        double dAvg = dSum / (double)iCount;
        double dExpectedAvg = 0.5 * Math.sqrt(dArea / (double)iCount);
        double dExpectedAvgC = 0.5 * Math.sqrt(dArea / (double)iCount) + (0.0514 + 0.041 / Math.sqrt(iCount)) * dPerimeter / (double)iCount;
        double dVar = 0.06830988618379069 * dArea / Math.pow(iCount, 2.0);
        double dVarC = 0.0703 * dArea / Math.pow(iCount, 2.0) + 0.037 * dPerimeter * Math.sqrt(dArea / Math.pow(iCount, 5.0));
        double dNNI = dAvg / dExpectedAvg;
        double dNNIC = dAvg / dExpectedAvgC;
        double dZ = (dAvg - dExpectedAvg) / Math.sqrt(dVar);
        double dZC = (dAvg - dExpectedAvgC) / Math.sqrt(dVarC);
        DecimalFormat df = new DecimalFormat("##.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Nearest_neighbour"));
        doc.addHeader(Sextante.getText((String)"Nearest_neighbour"), 2);
        doc.startUnorderedList();
        doc.addListElement(Sextante.getText((String)"Mean_distance") + ": " + df.format(dAvg));
        doc.addListElement(Sextante.getText((String)"Expected_distance") + ": " + df.format(dExpectedAvg));
        doc.addListElement(Sextante.getText((String)"Edge-corrected_expected_distance") + ": " + df.format(dExpectedAvgC));
        doc.addListElement(Sextante.getText((String)"Variance") + ": " + df.format(dVar));
        doc.addListElement(Sextante.getText((String)"Edge-corrected_variance") + ": " + df.format(dVarC));
        doc.addListElement(Sextante.getText((String)"Nearest_neighbour_index") + ": " + df.format(dNNI));
        doc.addListElement(Sextante.getText((String)"Corrected_nearest_neighbour_index") + ": " + df.format(dNNIC));
        doc.addListElement(Sextante.getText((String)"Z_value") + ": " + df.format(dZ));
        doc.addListElement(Sextante.getText((String)"Corrected_Z_value") + ": " + df.format(dZC));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(RESULT, Sextante.getText((String)"Statistics") + "[" + layer.getName() + "]", doc.getHTMLCode());
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Nearest_neighbour_analysis"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.addOutputText(RESULT, Sextante.getText((String)"Statistics"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

