/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.pointAnalysis.ripleysK;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.awt.geom.Rectangle2D;

public class RipleysKAlgorithm
extends GeoAlgorithm {
    private static final String POINTS = "POINTS";
    private static final String RESULT = "RESULT";
    private final int CLASSES = 30;
    private int m_iCount;
    private double m_dMaxDist = 0.0;
    private double m_dInterval;
    private double m_dArea;
    private double[] m_dK;
    private IVectorLayer m_Layer;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_iCount = this.m_Layer.getShapesCount();
        if (this.m_iCount == 0) {
            throw new GeoAlgorithmExecutionException("0 points in layer");
        }
        Rectangle2D rect = this.m_Layer.getFullExtent();
        this.m_dArea = rect.getHeight() * rect.getWidth();
        this.m_dMaxDist = Math.min(rect.getHeight(), rect.getWidth()) / 3.0;
        this.m_dInterval = this.m_dMaxDist / 30.0;
        double[][] d = new double[this.m_iCount][this.m_iCount];
        int i = 0;
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, this.m_iCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            double x1 = coord.x;
            double y1 = coord.y;
            int j = 0;
            for (IFeature feature2 : this.m_Layer) {
                Geometry geom2 = feature2.getGeometry();
                Coordinate coord2 = geom2.getCoordinate();
                double x2 = coord2.x;
                double y2 = coord2.y;
                double dDifX = x2 - x1;
                double dDifY = y2 - y1;
                d[i][j] = Math.sqrt(dDifX * dDifX + dDifY * dDifY);
                ++j;
            }
            ++i;
        }
        iter.close();
        this.calculate(d);
        this.createTables();
        return !this.m_Task.isCanceled();
    }

    private void createTables() throws UnsupportedOutputChannelException {
        String[] sFields = new String[]{Sextante.getText((String)"Distance"), Sextante.getText((String)"K"), Sextante.getText((String)"K_Poisson"), Sextante.getText((String)"L")};
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class};
        String sTableName = Sextante.getText((String)"Ripley_K") + "[" + this.m_Layer.getName() + "]";
        Object[] values = new Object[4];
        ITable driver = this.getNewTable(RESULT, sTableName, types, sFields);
        for (int i = 0; i < 30; ++i) {
            values[0] = new Double(this.m_dInterval * (double)i);
            values[1] = new Double(this.m_dK[i]);
            double dKPoisson = Math.PI * Math.pow((double)i * this.m_dInterval, 2.0);
            values[2] = new Double(dKPoisson);
            double dL = Math.sqrt(this.m_dK[i] / Math.PI) - (double)i * this.m_dInterval;
            values[3] = new Double(dL);
            driver.addRecord(values);
        }
    }

    private void calculate(double[][] dist) {
        this.m_dK = new double[30];
        for (int iClass = 1; iClass < 30; ++iClass) {
            double dDist = (double)iClass * this.m_dInterval;
            int iCount = 0;
            for (int i = 0; i < dist.length; ++i) {
                for (int j = 0; j < dist.length; ++j) {
                    if (!(dist[i][j] < dDist)) continue;
                    ++iCount;
                }
                this.setProgress(i, dist.length);
            }
            this.m_dK[iClass] = this.m_dArea / (double)(this.m_iCount * this.m_iCount) * (double)iCount;
        }
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Ripley_K"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), 0, true);
            this.addOutputTable(RESULT, Sextante.getText((String)"Ripley_K"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

