/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.profiles.flowLineProfile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.profiles.profile.ProfileAlgorithm;
import es.unex.sextante.rasterWrappers.GridCell;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jfree.chart.ChartPanel;

public class FlowLineProfileAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    public static final String GRAPH = "GRAPH";
    public static final String PROFILEPOINTS = "PROFILEPOINTS";
    public static final String POINT = "POINT";
    public static final String LAYERS = "LAYERS";
    public static final String DEM = "DEM";
    public static final String PROFILELINE = "PROFILELINE";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        OutputObjectsSet outputs;
        boolean bContinue = true;
        String[] sNames = new String[]{"ID"};
        Class[] types = new Class[]{Integer.class};
        Object[] value = new Object[1];
        ArrayList layers = this.m_Parameters.getParameterValueAsArrayList(LAYERS);
        IRasterLayer dem = this.m_Parameters.getParameterValueAsRasterLayer(DEM);
        Point2D pt = this.m_Parameters.getParameterValueAsPoint(POINT);
        dem.setFullExtent();
        AnalysisExtent extent = dem.getWindowGridExtent();
        GridCell cell = extent.getGridCoordsFromWorldCoords(pt);
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        coords.add(new Coordinate(pt.getX(), pt.getY()));
        do {
            int iDirection;
            if ((iDirection = dem.getDirToNextDownslopeCell(cell.getX(), cell.getY(), false)) >= 0) {
                cell.setX(cell.getX() + m_iOffsetX[iDirection]);
                cell.setY(cell.getY() + m_iOffsetY[iDirection]);
                pt = extent.getWorldCoordsFromGridCoords(cell);
                coords.add(new Coordinate(pt.getX(), pt.getY()));
                continue;
            }
            bContinue = false;
        } while (bContinue && !this.m_Task.isCanceled());
        if (this.m_Task.isCanceled()) {
            return false;
        }
        if (coords.size() > 1) {
            IVectorLayer lines = this.getNewVectorLayer(PROFILELINE, Sextante.getText((String)"Profile"), 1, types, sNames);
            value[0] = new Double(1.0);
            GeometryFactory gf = new GeometryFactory();
            Coordinate[] coordinates = new Coordinate[coords.size()];
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates[i] = (Coordinate)coords.get(i);
            }
            LineString line = gf.createLineString(coordinates);
            lines.addFeature((Geometry)line, value);
            try {
                lines.postProcess();
            }
            catch (Exception e) {
                throw new GeoAlgorithmExecutionException(e.getMessage());
            }
            ProfileAlgorithm profile = new ProfileAlgorithm();
            profile.getParameters().getParameter(DEM).setParameterValue((Object)dem);
            profile.getParameters().getParameter(LAYERS).setParameterValue((Object)layers);
            profile.getParameters().getParameter("ROUTE").setParameterValue((Object)lines);
            outputs = profile.getOutputObjects();
            outputs.getOutput(PROFILEPOINTS).setOutputChannel(this.getOutputChannel(PROFILEPOINTS));
            if (!profile.execute(this.m_Task, this.m_OutputFactory)) {
                return false;
            }
        } else {
            throw new GeoAlgorithmExecutionException("zero lines in layer");
        }
        IVectorLayer profilePts = (IVectorLayer)outputs.getOutput(PROFILEPOINTS).getOutputObject();
        this.m_OutputObjects.getOutput(PROFILEPOINTS).setOutputObject((Object)profilePts);
        ChartPanel cp = (ChartPanel)outputs.getOutput(GRAPH).getOutputObject();
        this.m_OutputObjects.getOutput(GRAPH).setOutputObject((Object)cp);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Flow_line_profile"));
        this.setGroup(Sextante.getText((String)"Profiles"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(DEM, Sextante.getText((String)"Elevation"), true);
            this.m_Parameters.addMultipleInput(LAYERS, Sextante.getText((String)"Additional_layers"), 1, false);
            this.m_Parameters.addPoint(POINT, Sextante.getText((String)"Starting_point"));
            this.addOutputVectorLayer(PROFILEPOINTS, Sextante.getText((String)"Profile_[points]"), 0);
            this.addOutputVectorLayer(PROFILELINE, Sextante.getText((String)"Profile_[line]"), 1);
            this.addOutputChart(GRAPH, Sextante.getText((String)"Profile"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

