/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.createEquivalentNumericalClass;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.util.ArrayList;

public class CreateEquivalentNumericalClassAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String NEW_FIELD_NAME = "NEW_FIELD_NAME";
    public static final String CLASS_FIELD = "CLASS_FIELD";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        ArrayList<String> list = new ArrayList<String>();
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        int iField = this.m_Parameters.getParameterValueAsInt(CLASS_FIELD);
        Class[] types = new Class[layerIn.getFieldCount() + 1];
        System.arraycopy(layerIn.getFieldTypes(), 0, types, 0, layerIn.getFieldCount());
        types[types.length - 1] = Integer.class;
        String[] sFields = new String[layerIn.getFieldCount() + 1];
        System.arraycopy(layerIn.getFieldNames(), 0, sFields, 0, layerIn.getFieldCount());
        sFields[types.length - 1] = this.m_Parameters.getParameterValueAsString(NEW_FIELD_NAME);
        IVectorLayer driver = this.getNewVectorLayer(RESULT, layerIn.getName(), layerIn.getShapeType(), types, sFields);
        IFeatureIterator iter = layerIn.iterator();
        int iTotal = layerIn.getShapesCount();
        int i = 0;
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            IRecord record = feature.getRecord();
            Object[] values = record.getValues();
            Object[] newValues = new Object[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            int iClass = list.indexOf(values[iField].toString());
            if (iClass == -1) {
                iClass = list.size();
                list.add(values[iField].toString());
            }
            newValues[values.length] = new Integer(iClass);
            driver.addFeature(feature.getGeometry(), newValues);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Create_equivalent_numerical_class"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_layer"), -1, true);
            this.m_Parameters.addString(NEW_FIELD_NAME, Sextante.getText((String)"name_for_new_field"), "CLASS_ID");
            this.m_Parameters.addTableField(CLASS_FIELD, Sextante.getText((String)"Class_field"), LAYER);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

