/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.tableFieldCorrelation;

import es.unex.sextante.additionalResults.CorrelationGraphCreator;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.docEngines.html.HTMLDoc;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.math.regression.Regression;
import java.text.DecimalFormat;

public class TableFieldCorrelationAlgorithm
extends GeoAlgorithm {
    public static final String METHOD = "METHOD";
    public static final String TABLE = "TABLE";
    public static final String FIELD = "FIELD";
    public static final String FIELD2 = "FIELD2";
    public static final String REGRESSION = "REGRESSION";
    public static final String REGRESSION_DATA = "REGRESSION_DATA";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Regression regression = new Regression();
        int iType = this.m_Parameters.getParameterValueAsInt(METHOD);
        ITable table = this.m_Parameters.getParameterValueAsTable(TABLE);
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int iField2 = this.m_Parameters.getParameterValueAsInt(FIELD2);
        int i = 0;
        long iCount = table.getRecordCount();
        IRecordsetIterator iter = table.iterator();
        while (iter.hasNext() && this.setProgress(i, (int)iCount)) {
            IRecord record = iter.next();
            try {
                double dValue = Double.parseDouble(record.getValue(iField).toString());
                double dValue2 = Double.parseDouble(record.getValue(iField2).toString());
                regression.addValue(dValue, dValue2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        iter.close();
        regression.calculate(iType);
        CorrelationGraphCreator panel = new CorrelationGraphCreator(regression);
        this.addOutputChart(REGRESSION, Sextante.getText((String)"Regression"), panel.getChartPanel());
        DecimalFormat df = new DecimalFormat("####.###");
        HTMLDoc doc = new HTMLDoc();
        doc.open(Sextante.getText((String)"Regression"));
        doc.addHeader(Sextante.getText((String)"Regression"), 2);
        doc.startUnorderedList();
        doc.addListElement(regression.getExpression());
        doc.addListElement("R\u00ef\u00bf\u00bd = " + df.format(regression.getR2()));
        doc.closeUnorderedList();
        doc.close();
        this.addOutputText(REGRESSION_DATA, Sextante.getText((String)"Regression_values"), doc.getHTMLCode());
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Best_fit"), "y = a + b * x", "y = a + b / x", "y = a / (b - x)", "y = a * x^b", "y = a e^(b * x)", "y = a + b * ln(x)"};
        this.setName(Sextante.getText((String)"Correlation_between_fields"));
        this.setGroup(Sextante.getText((String)"Table_tools"));
        try {
            this.m_Parameters.addInputTable(TABLE, Sextante.getText((String)"Table"), true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), TABLE);
            this.m_Parameters.addTableField(FIELD2, Sextante.getText((String)"Field2"), TABLE);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Equation"), sMethod);
            this.addOutputChart(REGRESSION, Sextante.getText((String)"Regression"));
            this.addOutputText(REGRESSION_DATA, Sextante.getText((String)"Regression_values"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

