/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.vectorHistogram;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class VectorHistogramAlgorithm
extends GeoAlgorithm {
    public static final String HISTOGRAM = "HISTOGRAM";
    public static final String FIELD = "FIELD";
    public static final String LAYER = "LAYER";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        int i = 0;
        ArrayList<Double> array = new ArrayList<Double>();
        int iShapesCount = layer.getShapesCount();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapesCount)) {
            IFeature feature = iter.next();
            try {
                double dValue = Double.parseDouble(feature.getRecord().getValue(iField).toString());
                array.add(new Double(dValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        iter.close();
        if (this.m_Task.isCanceled()) {
            return false;
        }
        HistogramDataset dataset = new HistogramDataset();
        double[] values = new double[array.size()];
        for (int j = 0; j < array.size(); ++j) {
            values[j] = (Double)array.get(j);
        }
        dataset.addSeries((Comparable)((Object)"Histogram"), values, 100);
        JFreeChart chart = ChartFactory.createHistogram((String)"", null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        ChartPanel jPanelChart = new ChartPanel(chart);
        jPanelChart.setMouseZoomable(true, true);
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setPreferredSize(new Dimension(500, 300));
        jPanelChart.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.addOutputChart(HISTOGRAM, Sextante.getText((String)"Histogram"), jPanelChart);
        return true;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Histogram"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LAYER);
            this.addOutputChart(HISTOGRAM, Sextante.getText((String)"Histogram"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

