/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tables.vectorSplitField;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.shapesTools.ShapesTools;

public class VectorSplitFieldAlgorithm
extends GeoAlgorithm {
    private static final Object NO_DATA = new Double(-99999.0);
    public static final String FIELD = "FIELD";
    public static final String BREAKPOINTS = "BREAKPOINTS";
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        String sBreakpoints = this.m_Parameters.getParameterValueAsString(BREAKPOINTS);
        String[] sTokens = sBreakpoints.split(",");
        int[] breakpoints = new int[sTokens.length + 2];
        breakpoints[0] = 0;
        breakpoints[breakpoints.length - 1] = 1000;
        for (int k = 0; k < sTokens.length; ++k) {
            breakpoints[k + 1] = Integer.parseInt(sTokens[k]);
        }
        Class[] types = new Class[sTokens.length + 1];
        for (int k = 0; k < types.length; ++k) {
            types[k] = String.class;
        }
        String sBaseName = layer.getFieldName(iField);
        String[] sFields = new String[sTokens.length + 1];
        for (int k = 0; k < sFields.length; ++k) {
            sFields[k] = sBaseName + "_" + Integer.toString(k);
        }
        int iTotalCount = layer.getShapesCount();
        Object[][] values = new String[breakpoints.length][iTotalCount];
        IFeatureIterator iter = layer.iterator();
        int iCount = 0;
        while (iter.hasNext() && this.setProgress(iCount, iTotalCount)) {
            IFeature feat = iter.next();
            String s = feat.getRecord().getValue(iField).toString();
            System.out.println(s);
            for (int k = 1; k < breakpoints.length; ++k) {
                int iMin = Math.min(breakpoints[k - 1], s.length());
                int iMin2 = Math.min(breakpoints[k], s.length());
                values[k - 1][iCount] = s.substring(iMin, iMin2);
            }
            ++iCount;
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setDescription(Sextante.getText((String)"Result"));
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)layer, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Split_field"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addString(BREAKPOINTS, Sextante.getText((String)"Breakpoints"));
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), LAYER);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

