/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.linearIsolinesFromTin;

import com.vividsolutions.jts.geom.Coordinate;
import es.unex.sextante.tin.linearIsolinesFromTin.BinaryTree;
import es.unex.sextante.tin.linearIsolinesFromTin.DVertex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class LinearContourLines {
    ArrayList finalIsolines = null;
    double elevatedStep;
    double clusterTol;
    double minIso;
    double maxIso;
    int numberOfIsolines;
    TreeMap treeIndex;

    public LinearContourLines(double equiDistance, double clusterTol) {
        this.elevatedStep = equiDistance;
        int coeficient = 1;
        while (clusterTol < 1.0) {
            coeficient *= 10;
            clusterTol *= 10.0;
        }
        this.clusterTol = coeficient * 10;
        this.finalIsolines = new ArrayList();
        this.treeIndex = new TreeMap();
    }

    private void trianglesIsoLines(Coordinate[] triangle) {
        Double minZ = new Double(0.0);
        Double maxZ = new Double(0.0);
        Coordinate startIZO = null;
        Coordinate stopIZO = null;
        double elev = Double.NEGATIVE_INFINITY;
        if (triangle[0].z / this.elevatedStep == (double)((int)(triangle[0].z / this.elevatedStep))) {
            triangle[0].z += this.elevatedStep * 0.01;
        }
        if (triangle[1].z / this.elevatedStep == (double)((int)(triangle[1].z / this.elevatedStep))) {
            triangle[1].z += this.elevatedStep * 0.01;
        }
        if (triangle[2].z / this.elevatedStep == (double)((int)(triangle[2].z / this.elevatedStep))) {
            triangle[2].z += this.elevatedStep * 0.01;
        }
        minZ = triangle[0].z;
        maxZ = triangle[0].z;
        if (minZ > triangle[1].z) {
            minZ = triangle[1].z;
        }
        if (minZ > triangle[2].z) {
            minZ = triangle[2].z;
        }
        if (maxZ < triangle[1].z) {
            maxZ = triangle[1].z;
        }
        if (maxZ < triangle[2].z) {
            maxZ = triangle[2].z;
        }
        if ((elev = minZ >= 0.0 ? (double)((int)(minZ / this.elevatedStep + 1.0)) * this.elevatedStep : (double)((int)(minZ / this.elevatedStep)) * this.elevatedStep) <= minZ) {
            elev += this.elevatedStep;
        }
        while (elev < maxZ) {
            if (triangle[0].z < elev & triangle[1].z > elev || triangle[0].z > elev & triangle[1].z < elev) {
                startIZO = this.solveLinearInterpolation(triangle[0], triangle[1], elev);
            }
            if (triangle[0].z < elev & triangle[2].z > elev || triangle[0].z > elev & triangle[2].z < elev) {
                if (startIZO == null) {
                    startIZO = this.solveLinearInterpolation(triangle[0], triangle[2], elev);
                } else {
                    stopIZO = this.solveLinearInterpolation(triangle[0], triangle[2], elev);
                }
            }
            if (triangle[1].z < elev & triangle[2].z > elev || triangle[1].z > elev & triangle[2].z < elev) {
                if (startIZO == null) {
                    startIZO = this.solveLinearInterpolation(triangle[1], triangle[2], elev);
                }
                if (stopIZO == null) {
                    stopIZO = this.solveLinearInterpolation(triangle[1], triangle[2], elev);
                }
            }
            startIZO.x = (double)Math.round(startIZO.x * this.clusterTol) / this.clusterTol;
            startIZO.y = (double)Math.round(startIZO.y * this.clusterTol) / this.clusterTol;
            stopIZO.x = (double)Math.round(stopIZO.x * this.clusterTol) / this.clusterTol;
            stopIZO.y = (double)Math.round(stopIZO.y * this.clusterTol) / this.clusterTol;
            if (!startIZO.equals2D(stopIZO)) {
                this.sortIsolines(startIZO, stopIZO, elev);
            }
            startIZO = null;
            stopIZO = null;
            elev += this.elevatedStep;
        }
    }

    private Coordinate solveLinearInterpolation(Coordinate A, Coordinate B, double elev) {
        if (B.z > A.z) {
            double rate = (elev - A.z) / (B.z - A.z);
            return new Coordinate(A.x + (B.x - A.x) * rate, A.y + (B.y - A.y) * rate, elev);
        }
        double rate = (elev - B.z) / (A.z - B.z);
        return new Coordinate(B.x + (A.x - B.x) * rate, B.y + (A.y - B.y) * rate, elev);
    }

    public void countIsolines(Coordinate[][] triangles) {
        for (int i = 0; i < triangles.length; ++i) {
            this.trianglesIsoLines(triangles[i]);
            triangles[i] = null;
        }
    }

    public ArrayList getIsolines() {
        return this.finalIsolines;
    }

    private void sortIsolines(Coordinate coordA, Coordinate coordB, double elevation) {
        DVertex izoA = null;
        DVertex izoB = null;
        int indexA = 0;
        int indexB = 0;
        BinaryTree tree = null;
        int elevIndex = new Double((elevation - this.minIso) / this.elevatedStep).intValue();
        if (this.treeIndex.containsKey(elevIndex)) {
            tree = (BinaryTree)this.treeIndex.get(elevIndex);
        } else {
            tree = new BinaryTree();
            this.treeIndex.put(elevIndex, tree);
        }
        izoA = (DVertex)tree.search(coordA);
        izoB = (DVertex)tree.search(coordB);
        if (izoA != null) {
            indexA = 1;
        }
        if (izoB != null) {
            indexB = 2;
        }
        switch (indexA + indexB) {
            case 0: {
                LinkedList<Coordinate> izoList = new LinkedList<Coordinate>();
                izoList.add(coordA);
                izoList.add(coordB);
                tree.insert(coordA, new Integer(this.finalIsolines.size()));
                tree.insert(coordB, new Integer(this.finalIsolines.size()));
                this.finalIsolines.add(this.finalIsolines.size(), izoList);
                break;
            }
            case 1: {
                LinkedList izoList = (LinkedList)this.finalIsolines.get(izoA.data);
                if (izoList == null) break;
                tree.remove(coordA);
                if (((Coordinate)izoList.getFirst()).equals2D(coordA)) {
                    izoList.addFirst(coordB);
                    tree.insert(coordB, izoA.data);
                    break;
                }
                izoList.addLast(coordB);
                tree.insert(coordB, izoA.data);
                break;
            }
            case 2: {
                LinkedList izoList = (LinkedList)this.finalIsolines.get(izoB.data);
                if (izoList == null) break;
                tree.remove(coordB);
                if (((Coordinate)izoList.getFirst()).equals2D(coordB)) {
                    izoList.addFirst(coordA);
                    tree.insert(coordA, izoB.data);
                    break;
                }
                izoList.addLast(coordA);
                tree.insert(coordA, izoB.data);
                break;
            }
            case 3: {
                LinkedList izoList = (LinkedList)this.finalIsolines.get(izoA.data);
                if (izoList == null) break;
                if (izoA.data.intValue() == izoB.data.intValue()) {
                    tree.remove(coordA);
                    tree.remove(coordB);
                    if (((Coordinate)izoList.getFirst()).equals2D(coordA)) {
                        izoList.addLast(coordA);
                    } else {
                        izoList.addFirst(coordA);
                    }
                } else {
                    LinkedList izoListB = (LinkedList)this.finalIsolines.get(izoB.data);
                    if (izoListB == null) break;
                    if (((Coordinate)izoList.getFirst()).equals2D(coordA)) {
                        if (((Coordinate)izoListB.getFirst()).equals2D(coordB)) {
                            Iterator iterIzoB = izoListB.iterator();
                            while (iterIzoB.hasNext()) {
                                izoList.addFirst(iterIzoB.next());
                            }
                        } else {
                            Iterator iterIzoB = izoListB.descendingIterator();
                            while (iterIzoB.hasNext()) {
                                izoList.addFirst(iterIzoB.next());
                            }
                        }
                    } else if (((Coordinate)izoListB.getFirst()).equals2D(coordB)) {
                        Iterator iterIzoB = izoListB.iterator();
                        while (iterIzoB.hasNext()) {
                            izoList.addLast(iterIzoB.next());
                        }
                    } else {
                        Iterator iterIzoB = izoListB.descendingIterator();
                        while (iterIzoB.hasNext()) {
                            izoList.addLast(iterIzoB.next());
                        }
                    }
                    this.finalIsolines.set(izoB.data, null);
                    ((DVertex)tree.search((Coordinate)((Coordinate)izoList.getLast()))).data = izoA.data;
                    ((DVertex)tree.search((Coordinate)((Coordinate)izoList.getFirst()))).data = izoA.data;
                }
                tree.remove(coordA);
                tree.remove(coordB);
            }
        }
    }
}

