/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.smoothTinBezier;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.GeneralPath;

public class Bezier {
    Coordinate b300;
    Coordinate b030;
    Coordinate b003;
    Coordinate b012 = null;
    Coordinate b021 = null;
    Coordinate b102 = null;
    Coordinate b120 = null;
    Coordinate b210 = null;
    Coordinate b201 = null;
    Coordinate b111 = null;
    GeneralPath trianglePath = new GeneralPath();

    protected Bezier(Coordinate b300, Coordinate b030, Coordinate b003, Coordinate b210, Coordinate b120, Coordinate b021, Coordinate b012, Coordinate b102, Coordinate b201, Coordinate b111) {
        this.b300 = b300;
        this.b030 = b030;
        this.b003 = b003;
        this.b012 = b012;
        this.b021 = b021;
        this.b102 = b102;
        this.b120 = b120;
        this.b210 = b210;
        this.b201 = b201;
        this.b111 = b111;
        this.trianglePath.moveTo((float)b300.x, (float)b300.y);
        this.trianglePath.lineTo((float)b030.x, (float)b030.y);
        this.trianglePath.lineTo((float)b003.x, (float)b003.y);
        this.trianglePath.lineTo((float)b300.x, (float)b300.y);
        this.trianglePath.closePath();
    }

    protected Coordinate getElevation(double u, double v, double scaleZ) {
        double w = 1.0 - u - v;
        double x = this.b300.x * Math.pow(w, 3.0) + this.b030.x * Math.pow(u, 3.0) + this.b003.x * Math.pow(v, 3.0) + 3.0 * this.b210.x * Math.pow(w, 2.0) * u + 3.0 * this.b120.x * Math.pow(u, 2.0) * w + 3.0 * this.b201.x * Math.pow(w, 2.0) * v + 3.0 * this.b021.x * Math.pow(u, 2.0) * v + 3.0 * this.b102.x * Math.pow(v, 2.0) * w + 3.0 * this.b012.x * u * Math.pow(v, 2.0) + 6.0 * this.b111.x * u * v * w;
        double y = this.b300.y * Math.pow(w, 3.0) + this.b030.y * Math.pow(u, 3.0) + this.b003.y * Math.pow(v, 3.0) + 3.0 * this.b210.y * Math.pow(w, 2.0) * u + 3.0 * this.b120.y * Math.pow(u, 2.0) * w + 3.0 * this.b201.y * Math.pow(w, 2.0) * v + 3.0 * this.b021.y * Math.pow(u, 2.0) * v + 3.0 * this.b102.y * Math.pow(v, 2.0) * w + 3.0 * this.b012.y * u * Math.pow(v, 2.0) + 6.0 * this.b111.y * u * v * w;
        double z = (this.b300.z * Math.pow(w, 3.0) + this.b030.z * Math.pow(u, 3.0) + this.b003.z * Math.pow(v, 3.0) + 3.0 * this.b210.z * Math.pow(w, 2.0) * u + 3.0 * this.b120.z * Math.pow(u, 2.0) * w + 3.0 * this.b201.z * Math.pow(w, 2.0) * v + 3.0 * this.b021.z * Math.pow(u, 2.0) * v + 3.0 * this.b102.z * Math.pow(v, 2.0) * w + 3.0 * this.b012.z * u * Math.pow(v, 2.0) + 6.0 * this.b111.z * u * v * w) * scaleZ;
        return new Coordinate(x, y, z);
    }

    protected void printToConsole() {
        System.out.println("======================================");
        System.out.println(this.b300.toString());
        System.out.println(this.b030.toString());
        System.out.println(this.b003.toString());
        System.out.println("Normals:");
        System.out.println(this.b210.toString());
        System.out.println(this.b120.toString());
        System.out.println(this.b021.toString());
        System.out.println(this.b012.toString());
        System.out.println(this.b102.toString());
        System.out.println(this.b201.toString());
        System.out.println(this.b111.toString());
        System.out.println("======================================");
    }

    public boolean contains(Coordinate P) {
        return this.trianglePath.contains(P.x, P.y);
    }
}

