/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tridimensional.line3DFromTable;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import java.util.ArrayList;

public class Line3DFromTableAlgorithm
extends GeoAlgorithm {
    public static final String TABLE = "TABLE";
    public static final String XFIELD = "XFIELD";
    public static final String YFIELD = "YFIELD";
    public static final String ZFIELD = "ZFIELD";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        ITable table = this.m_Parameters.getParameterValueAsTable(TABLE);
        int iFieldX = this.m_Parameters.getParameterValueAsInt(XFIELD);
        int iFieldY = this.m_Parameters.getParameterValueAsInt(YFIELD);
        int iFieldZ = this.m_Parameters.getParameterValueAsInt(ZFIELD);
        String[] sFields = new String[]{"ID"};
        Class[] types = new Class[]{Integer.class};
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"3DLineFromTable"), 1, types, sFields);
        ArrayList<Coordinate> coordsArray = new ArrayList<Coordinate>();
        IRecordsetIterator iter = table.iterator();
        GeometryFactory geomFac = new GeometryFactory();
        while (iter.hasNext()) {
            try {
                IRecord record = iter.next();
                String sX = record.getValue(iFieldX).toString();
                String sY = record.getValue(iFieldY).toString();
                String sZ = record.getValue(iFieldZ).toString();
                double dX = Double.parseDouble(sX);
                double dY = Double.parseDouble(sY);
                double dZ = Double.parseDouble(sZ);
                coordsArray.add(new Coordinate(dX, dY, dZ));
            }
            catch (NumberFormatException record) {}
        }
        iter.close();
        if (coordsArray.size() <= 1) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"LessThanTwoPointsInTable"));
        }
        LineString line = geomFac.createLineString(coordsArray.toArray(new Coordinate[0]));
        output.addFeature((Geometry)line, new Object[]{new Integer(1)});
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"3DLineFromTable"));
        this.setGroup(Sextante.getText((String)"3D"));
        try {
            this.m_Parameters.addInputTable(TABLE, Sextante.getText((String)"Table"), true);
            this.m_Parameters.addTableField(XFIELD, Sextante.getText((String)"X"), TABLE);
            this.m_Parameters.addTableField(YFIELD, Sextante.getText((String)"Y"), TABLE);
            this.m_Parameters.addTableField(ZFIELD, Sextante.getText((String)"Z"), TABLE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean isActive() {
        return false;
    }
}

