/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.InPolygonSpatialJoinB;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.vectorTools.InPolygonSpatialJoinB.NearestNeighbourFinder;

public class InPolygonSpatialJoinBAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String MAIN = "MAIN";
    public static final String SECONDARY = "SECONDARY";
    public static final String FIELD = "FIELD";
    private IVectorLayer m_MainLayer;
    private IVectorLayer m_SecondaryLayer;
    private IVectorLayer m_Output;
    private NearestNeighbourFinder m_NNF;
    private int m_iField;
    private Class m_Type;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"InPolygonSpatialJoinB"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(MAIN, Sextante.getText((String)"Polygons"), 2, true);
            this.m_Parameters.addInputVectorLayer(SECONDARY, Sextante.getText((String)"Secondary_layer"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), MAIN);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 2, SECONDARY);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        this.m_MainLayer = this.m_Parameters.getParameterValueAsVectorLayer(MAIN);
        this.m_SecondaryLayer = this.m_Parameters.getParameterValueAsVectorLayer(SECONDARY);
        if (!this.m_bIsAutoExtent) {
            this.m_MainLayer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_SecondaryLayer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_iField = this.m_Parameters.getParameterValueAsInt(FIELD);
        String[] sFields = new String[this.m_SecondaryLayer.getFieldCount() + 1];
        Class[] types = new Class[this.m_SecondaryLayer.getFieldCount() + 1];
        for (i = 0; i < this.m_SecondaryLayer.getFieldCount(); ++i) {
            sFields[i] = this.m_SecondaryLayer.getFieldName(i);
            types[i] = this.m_SecondaryLayer.getFieldType(i);
        }
        sFields[this.m_SecondaryLayer.getFieldCount()] = this.m_MainLayer.getFieldName(this.m_iField);
        types[this.m_SecondaryLayer.getFieldCount()] = this.m_Type = this.m_MainLayer.getFieldType(this.m_iField);
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_SecondaryLayer.getName(), this.m_SecondaryLayer.getShapeType(), types, sFields);
        this.m_NNF = new NearestNeighbourFinder(this.m_MainLayer, this.m_Task);
        int iShapeCount = this.m_SecondaryLayer.getShapesCount();
        i = 0;
        this.setProgressText(Sextante.getText((String)"Processing"));
        IFeatureIterator iter = this.m_SecondaryLayer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            this.performSpatialJoin(feature);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void performSpatialJoin(IFeature feature) {
        IFeature[] polygons;
        Geometry geom = feature.getGeometry();
        for (IFeature polygon : polygons = this.m_NNF.getClosestPoints(geom)) {
            if (!polygon.getGeometry().contains(geom)) continue;
            this.m_Output.addFeature(feature.getGeometry(), this.calculateRecord(polygon.getRecord().getValue(this.m_iField), feature.getRecord().getValues()));
            return;
        }
        Object value = Integer.class.isAssignableFrom(this.m_Type) ? new Integer(-99999) : (Double.class.isAssignableFrom(this.m_Type) ? new Integer(-99999) : "");
        this.m_Output.addFeature(feature.getGeometry(), this.calculateRecord(value, feature.getRecord().getValues()));
    }

    private Object[] calculateRecord(Object value, Object[] record) {
        Object[] values = new Object[record.length + 1];
        System.arraycopy(record, 0, values, 0, record.length);
        values[values.length - 1] = value;
        return values;
    }
}

