/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.addEventTheme;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IRecordsetIterator;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public class AddEventThemeAlgorithm
extends GeoAlgorithm {
    public static final String TABLE = "TABLE";
    public static final String XFIELD = "XFIELD";
    public static final String RESULT = "RESULT";
    public static final String YFIELD = "YFIELD";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        ITable table = this.m_Parameters.getParameterValueAsTable(TABLE);
        int iFieldX = this.m_Parameters.getParameterValueAsInt(XFIELD);
        int iFieldY = this.m_Parameters.getParameterValueAsInt(YFIELD);
        String[] sFields = new String[table.getFieldCount()];
        Class[] types = new Class[table.getFieldCount()];
        for (int j = 0; j < table.getFieldCount(); ++j) {
            sFields[j] = table.getFieldName(j);
            types[j] = table.getFieldType(j);
        }
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Layer_from_table"), 0, types, sFields);
        IRecordsetIterator iter = table.iterator();
        GeometryFactory geomFac = new GeometryFactory();
        while (iter.hasNext()) {
            try {
                IRecord record = iter.next();
                String sX = record.getValue(iFieldX).toString();
                String sY = record.getValue(iFieldY).toString();
                double dX = Double.parseDouble(sX);
                double dY = Double.parseDouble(sY);
                Point pt = geomFac.createPoint(new Coordinate(dX, dY));
                output.addFeature((Geometry)pt, record.getValues());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Points_layer_from_table"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        try {
            this.m_Parameters.addInputTable(TABLE, Sextante.getText((String)"Table"), true);
            this.m_Parameters.addTableField(XFIELD, Sextante.getText((String)"X"), TABLE);
            this.m_Parameters.addTableField(YFIELD, Sextante.getText((String)"Y"), TABLE);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

