/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.boundingbox;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.gvsig.tools.exception.BaseException;

public class BoundingBoxAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int subtype;
        int i = 0;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        try {
            subtype = layerIn.getSubType();
        }
        catch (BaseException e) {
            subtype = 4;
        }
        IVectorLayer result = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Bounding Box"), 2, layerIn.getFieldTypes(), layerIn.getFieldNames(), subtype);
        IFeatureIterator iter = layerIn.iterator();
        int iTotal = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            Geometry bbox = this.getBBox(feature.getGeometry());
            result.addFeature(bbox, feature.getRecord().getValues());
            this.setProgress(i, iTotal);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Bounding_Box"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), new AdditionalInfoVectorLayer(true, 6));
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Bounding_Box"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private Geometry getBBox(Geometry geometry) {
        return geometry.getEnvelope();
    }
}

