/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.centroids;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CentroidsAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        IVectorLayer result = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Centroids"), 0, layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int iTotal = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            Point centroid = this.getCentroid(feature.getGeometry());
            result.addFeature((Geometry)centroid, feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Centroids"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Vector_layer"), -1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Centroids"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private Point getCentroid(Geometry geometry) {
        return geometry.getCentroid();
    }
}

