/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.clipByRectangle;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.vectorTools.clip.ClipAlgorithm;

public class ClipByRectangleAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String YMAX = "YMAX";
    public static final String XMAX = "XMAX";
    public static final String YMIN = "YMIN";
    public static final String XMIN = "XMIN";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Clip_by_rectangle"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer_to_clip"), -1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Clipped_Layer"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        STRtree tree = this.buildClipTree();
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Clipped_Layer"), layerIn.getShapeType(), layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int i = 0;
        int iShapeCount = layerIn.getShapesCount();
        ClipAlgorithm alg = new ClipAlgorithm();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry g = alg.clipGeometry(feature.getGeometry(), tree);
            if (g != null) {
                this.m_Output.addFeature(g, feature.getRecord().getValues());
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private STRtree buildClipTree() {
        STRtree tree = new STRtree();
        Geometry geom = this.m_AnalysisExtent.getAsJTSGeometry();
        PreparedGeometry pg = PreparedGeometryFactory.prepare((Geometry)geom);
        tree.insert(pg.getGeometry().getEnvelopeInternal(), (Object)pg);
        return tree;
    }
}

