/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.dissolveMultiple;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class DissolveMultipleAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    public static final String GROUPING_FIELDS = "GROUPING_FIELD";
    public static final String GROUPING_FUNCTIONS = "GROUPING_FUNCTIONS";
    public static final int SUM = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int AVG = 3;
    public static final String[] FUNCTIONS = new String[]{"SUM", "MIN", "MAX", "AVG"};
    private IVectorLayer m_LayerIn;
    private int[] m_iFields;
    private Grouping[] m_Groupings;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Geometry geom;
        int i;
        this.m_LayerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.m_LayerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_iFields = this.getFields(this.m_Parameters.getParameterValueAsString(GROUPING_FIELDS));
        String sGroupings = this.m_Parameters.getParameterValueAsString(GROUPING_FUNCTIONS);
        this.m_Groupings = this.getGroupings(sGroupings);
        String[] sFields = new String[this.m_iFields.length + this.m_Groupings.length];
        Class[] types = new Class[this.m_iFields.length + this.m_Groupings.length];
        for (i = 0; i < types.length; ++i) {
            sFields[i] = this.m_LayerIn.getFieldName(this.m_iFields[i]);
            types[i] = this.m_LayerIn.getFieldType(this.m_iFields[i]);
        }
        for (i = 0; i < this.m_Groupings.length; ++i) {
            sFields[i + this.m_iFields.length] = this.m_LayerIn.getFieldName(this.m_Groupings[i].field) + "_" + FUNCTIONS[this.m_Groupings[i].function];
            types[i + this.m_iFields.length] = Double.class;
        }
        IVectorLayer output = this.getNewVectorLayer(RESULT, this.m_LayerIn.getName(), this.m_LayerIn.getShapeType(), types, sFields);
        int iShapesCount = this.m_LayerIn.getShapesCount();
        HashMap geoms = new HashMap();
        HashMap[] stats = new HashMap[this.m_LayerIn.getFieldCount()];
        for (int i2 = 0; i2 < stats.length; ++i2) {
            stats[i2] = new HashMap();
        }
        IFeatureIterator iter = this.m_LayerIn.iterator();
        int i3 = 0;
        while (iter.hasNext() && this.setProgress(i3, iShapesCount)) {
            IFeature feature = iter.next();
            ArrayList<Object> clazz = new ArrayList<Object>();
            IRecord record = feature.getRecord();
            for (int j = 0; j < this.m_iFields.length; ++j) {
                clazz.add(record.getValue(this.m_iFields[j]));
            }
            geom = (Geometry)geoms.get(clazz);
            if (geom == null) {
                geoms.put(clazz, feature.getGeometry());
                for (HashMap element : stats) {
                    element.put(clazz, new SimpleStats());
                }
            } else {
                Geometry[] geomsToUnion = new Geometry[]{geom, feature.getGeometry()};
                GeometryFactory fact = geom.getFactory();
                GeometryCollection geomColl = fact.createGeometryCollection(geomsToUnion);
                geoms.put(clazz, geomColl);
            }
            for (int j = 0; j < stats.length; ++j) {
                try {
                    double dValue = Double.parseDouble(record.getValue(j).toString());
                    ((SimpleStats)stats[j].get(clazz)).addValue(dValue);
                    continue;
                }
                catch (Exception dValue) {
                    // empty catch block
                }
            }
            ++i3;
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        Set set = geoms.keySet();
        Iterator keys = set.iterator();
        i3 = 0;
        while (keys.hasNext() && this.setProgress(i3, geoms.size())) {
            ArrayList clazz = (ArrayList)keys.next();
            geom = ((Geometry)geoms.get(clazz)).union();
            SimpleStats[] stat = new SimpleStats[this.m_LayerIn.getFieldCount()];
            for (int j = 0; j < stat.length; ++j) {
                stat[j] = (SimpleStats)stats[j].get(clazz);
            }
            Object[] values = this.calculateRecord(stat, clazz);
            output.addFeature(geom, values);
            ++i3;
        }
        return !this.m_Task.isCanceled();
    }

    private int[] getFields(String sFields) throws GeoAlgorithmExecutionException {
        String[] fields = sFields.split(",");
        if (fields.length == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"At_Least_One_Field_Needed"));
        }
        int[] iFields = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            iFields[i] = this.m_LayerIn.getFieldIndexByName(fields[i]);
            if (iFields[i] != -1) continue;
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"Wrong_Field_Name") + ":" + fields[i]);
        }
        return iFields;
    }

    private Object[] calculateRecord(SimpleStats[] stats, ArrayList clazz) {
        int i;
        Object[] values = new Object[this.m_Groupings.length + this.m_iFields.length];
        for (i = 0; i < this.m_iFields.length; ++i) {
            values[i] = clazz.get(i);
        }
        for (i = 0; i < this.m_Groupings.length; ++i) {
            double dValue;
            int iField = this.m_Groupings[i].field;
            int iFunction = this.m_Groupings[i].function;
            switch (iFunction) {
                case 1: {
                    dValue = stats[iField].getMin();
                    break;
                }
                case 2: {
                    dValue = stats[iField].getMax();
                    break;
                }
                case 0: {
                    dValue = stats[iField].getSum();
                    break;
                }
                default: {
                    dValue = stats[iField].getMean();
                }
            }
            values[i + this.m_iFields.length] = stats[iField].getCount() > 0 ? new Double(dValue) : null;
        }
        return values;
    }

    private Grouping[] getGroupings(String sGroupings) throws GeoAlgorithmExecutionException {
        if (sGroupings.trim().equals("")) {
            return new Grouping[0];
        }
        try {
            String[] sTokens = sGroupings.split(",");
            if (sTokens.length % 2 != 0) {
                throw new GeoAlgorithmExecutionException("Wrong groupings");
            }
            Grouping[] groupings = new Grouping[sTokens.length / 2];
            boolean iGrouping = false;
            for (int i = 0; i < sTokens.length; ++i) {
                groupings[0] = new Grouping();
                groupings[0].field = Integer.parseInt(sTokens[i]);
                if (groupings[0].field >= this.m_LayerIn.getFieldCount() || groupings[0].field < 0) {
                    throw new GeoAlgorithmExecutionException("Wrong groupings");
                }
                groupings[0].function = Integer.parseInt(sTokens[++i]);
                if (groupings[0].function <= 4 && groupings[0].function >= 0) continue;
                throw new GeoAlgorithmExecutionException("Wrong groupings");
            }
            return groupings;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException("Wrong groupings");
        }
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Dissolve_multiple"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), -1, true);
            this.m_Parameters.addString(GROUPING_FIELDS, Sextante.getText((String)"Fields"));
            this.m_Parameters.addString(GROUPING_FUNCTIONS, Sextante.getText((String)"Summary_statistics"));
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private class Grouping {
        public int field;
        public int function;
    }
}

