/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.distanceAndAngle;

import com.vividsolutions.jts.algorithm.distance.DiscreteHausdorffDistance;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;

public class DistanceAndAngleAlgorithm
extends GeoAlgorithm {
    public static final String LAYER1 = "LAYER1";
    public static final String FIELD1 = "ID1";
    public static final String CONVEXHULL1 = "CONVEXHULL1";
    public static final String LAYER2 = "LAYER2";
    public static final String FIELD2 = "ID2";
    public static final String CONVEXHULL2 = "CONVEXHULL2";
    public static final String RESULT_POINTS = "POINTS";
    public static final String RESULT_LINES = "LINES";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i = 0;
        int j = 0;
        IVectorLayer layer1 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER1);
        int id1_idx = this.m_Parameters.getParameterValueAsInt(FIELD1);
        boolean useConvexHull1 = this.m_Parameters.getParameterValueAsBoolean(CONVEXHULL1);
        IVectorLayer layer2 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER2);
        int id2_idx = this.m_Parameters.getParameterValueAsInt(FIELD2);
        boolean useConvexHull2 = this.m_Parameters.getParameterValueAsBoolean(CONVEXHULL2);
        if (!this.m_bIsAutoExtent) {
            layer1.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            layer2.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iCount1 = layer1.getShapesCount();
        String[] linesFields = new String[]{"UID_A", "UID_B", "MIN_DIST", "CENTR_DIST", "HAUSD_DIST", "BEARING"};
        Class[] linesTypes = new Class[]{String.class, String.class, Double.class, Double.class, Double.class, Double.class};
        IVectorLayer driver = this.getNewVectorLayer(RESULT_LINES, Sextante.getText((String)"Lines_Dist_Angles"), 1, linesTypes, linesFields);
        IFeatureIterator iter1 = layer1.iterator();
        while (iter1.hasNext() && this.setProgress(i, iCount1)) {
            Object[] linesValues = new Object[linesFields.length];
            IFeature feature1 = iter1.next();
            Geometry geom1 = feature1.getGeometry();
            if (useConvexHull1) {
                geom1 = geom1.convexHull();
            }
            Point geom1_c = geom1.getCentroid();
            Coordinate coord1 = geom1_c.getCoordinate();
            double x1 = coord1.x;
            double y1 = coord1.y;
            IFeatureIterator iter2 = layer2.iterator();
            linesValues[0] = feature1.getRecord().getValue(id1_idx).toString();
            j = 0;
            GeometryFactory gf = new GeometryFactory();
            while (iter2.hasNext()) {
                IFeature feature2 = iter2.next();
                Geometry geom2 = feature2.getGeometry();
                if (useConvexHull2) {
                    geom2 = geom2.convexHull();
                }
                Point geom2_c = geom2.getCentroid();
                Coordinate coord2 = geom2_c.getCoordinate();
                double x2 = coord2.x;
                double y2 = coord2.y;
                double dX = x2 - x1;
                double dY = y2 - y1;
                linesValues[1] = feature2.getRecord().getValue(id2_idx).toString();
                double min_dist = geom1.distance(geom2);
                linesValues[2] = min_dist;
                double centroid_dist = geom1_c.distance((Geometry)geom2_c);
                linesValues[3] = centroid_dist;
                DiscreteHausdorffDistance hausdorff = new DiscreteHausdorffDistance(geom1, geom2);
                double hausd_dist = hausdorff.distance();
                linesValues[4] = hausd_dist;
                Double slope = dY / dX;
                if (Double.isNaN(slope)) {
                    slope = 0.0;
                }
                if (Double.isInfinite(slope)) {
                    slope = dY < 0.0 ? Double.valueOf(Double.MIN_VALUE) : Double.valueOf(Double.MAX_VALUE);
                }
                int quadrant = 0;
                quadrant = dX < 0.0 ? (slope < 0.0 ? 1 : 2) : (slope < 0.0 ? 3 : 0);
                if (centroid_dist == 0.0) {
                    linesValues[5] = -1;
                } else if (Double.MIN_VALUE == slope) {
                    linesValues[5] = 180;
                } else {
                    double angle_aux = Math.toDegrees(Math.atan(slope));
                    switch (quadrant) {
                        case 0: {
                            linesValues[5] = 90.0 - angle_aux;
                            break;
                        }
                        case 1: {
                            linesValues[5] = 270.0 - angle_aux;
                            break;
                        }
                        case 2: {
                            linesValues[5] = 270.0 - angle_aux;
                            break;
                        }
                        case 3: {
                            linesValues[5] = Math.abs(angle_aux) + 90.0;
                        }
                    }
                }
                driver.addFeature((Geometry)gf.createLineString(new Coordinate[]{coord1, coord2}), linesValues);
                ++j;
            }
            iter2.close();
            ++i;
        }
        iter1.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Distances_and_Angles"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER1, Sextante.getText((String)"Layer_1"), -1, true);
            this.m_Parameters.addTableField(FIELD1, Sextante.getText((String)"ID1_FIELDNAME"), LAYER1);
            this.m_Parameters.addBoolean(CONVEXHULL1, Sextante.getText((String)"ConvexHull_of_layer_1"), true);
            this.m_Parameters.addInputVectorLayer(LAYER2, Sextante.getText((String)"Layer_2"), -1, true);
            this.m_Parameters.addTableField(FIELD2, Sextante.getText((String)"ID2_FIELDNAME"), LAYER2);
            this.m_Parameters.addBoolean(CONVEXHULL2, Sextante.getText((String)"ConvexHull_of_Layer_2"), true);
            this.addOutputVectorLayer(RESULT_LINES, Sextante.getText((String)"Lines_Dist_Angles"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

