/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.distanceTableBuffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.parameters.FixedTableModel;
import java.util.ArrayList;
import java.util.Arrays;

public class DistanceTableBufferAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String NOTROUNDED = "NOTROUNDED";
    public static final String LAYER = "LAYER";
    public static final String DISTANCES = "DISTANCES";
    private IVectorLayer m_Output;
    private boolean m_bRounded;
    private int m_iNumProcessed = 0;
    private Double[] m_Distances;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        FixedTableModel distances = (FixedTableModel)this.m_Parameters.getParameterValueAsObject(DISTANCES);
        ArrayList<Double> distancesList = new ArrayList<Double>();
        for (int i2 = 0; i2 < distances.getRowCount(); ++i2) {
            try {
                double dDistance = Double.parseDouble(distances.getValueAt(i2, 0).toString());
                if (!(dDistance > 0.0)) continue;
                distancesList.add(new Double(dDistance));
                continue;
            }
            catch (Exception dDistance) {
                // empty catch block
            }
        }
        if (distancesList.size() == 0) {
            throw new GeoAlgorithmExecutionException(Sextante.getText((String)"No_Elements_In_Distance_List"));
        }
        this.m_Distances = distancesList.toArray(new Double[0]);
        Arrays.sort((Object[])this.m_Distances);
        this.m_bRounded = !this.m_Parameters.getParameterValueAsBoolean(NOTROUNDED);
        int iFieldCount = layerIn.getFieldCount();
        Class[] types = new Class[iFieldCount + 2];
        types[0] = Integer.class;
        types[1] = Double.class;
        String[] sFieldNames = new String[iFieldCount + 2];
        sFieldNames[0] = "ID";
        sFieldNames[1] = "DIST";
        for (i = 0; i < iFieldCount; ++i) {
            sFieldNames[i + 2] = this.checkAttrName(layerIn.getFieldName(i), i + 2, sFieldNames);
            types[i + 2] = layerIn.getFieldType(i);
        }
        this.m_Output = this.getNewVectorLayer(RESULT, "Buffer", 2, types, sFieldNames);
        i = 0;
        int iTotal = layerIn.getShapesCount();
        IFeatureIterator iter = layerIn.iterator();
        while (iter.hasNext() && this.setProgress(i, iTotal)) {
            IFeature feature = iter.next();
            this.computeBuffer(feature.getGeometry(), feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Multiple_buffer"));
        this.setGroup(Sextante.getText((String)"Buffers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_layer"), -1, true);
            this.m_Parameters.addFixedTable(DISTANCES, Sextante.getText((String)"Distances_table"), new String[]{Sextante.getText((String)"Distance")}, 3, false);
            this.m_Parameters.addBoolean(NOTROUNDED, Sextante.getText((String)"Do_not_round_resulting_polygons"), false);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Buffer"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void computeBuffer(Geometry originalGeometry, Object[] record) {
        Geometry solution = null;
        Geometry inputParam = originalGeometry;
        int cap = 1;
        if (!this.m_bRounded) {
            cap = 3;
        }
        Geometry previousExteriorRing = null;
        for (int i = 0; i < this.m_Distances.length; ++i) {
            double dDistRing = this.m_Distances[i];
            BufferOp bufOp = new BufferOp(inputParam);
            bufOp.setEndCapStyle(cap);
            Geometry newGeometry = bufOp.getResultGeometry(dDistRing);
            solution = previousExteriorRing != null ? newGeometry.difference(previousExteriorRing) : newGeometry;
            ++this.m_iNumProcessed;
            this.addFeature(solution, dDistRing, record);
            previousExteriorRing = newGeometry;
        }
    }

    protected void addFeature(Geometry geom, double dDistance, Object[] record) {
        Object[] values = new Object[2 + record.length];
        values[0] = new Long(this.m_iNumProcessed);
        values[1] = new Double(dDistance);
        for (int i = 0; i < record.length; ++i) {
            values[i + 2] = record[i];
        }
        this.m_Output.addFeature(geom, values);
    }
}

