/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.extendLinesLayerWithGrids;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.RasterLayerAndBand;
import es.unex.sextante.shapesTools.ShapesTools;
import java.util.ArrayList;

public class ExtendLinesLayerWithGridsAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String GRIDS = "GRIDS";
    public static final String INTERPOLATE = "INTERPOLATE";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;
    private ArrayList m_Grids;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Sample_lines_extreme_points"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Input_layer"), 1, true);
            this.m_Parameters.addMultipleInput(GRIDS, Sextante.getText((String)"Raster_layers"), 7, true);
            this.m_Parameters.addBoolean(INTERPOLATE, Sextante.getText((String)"Use_interpolation"), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Sampled_lines"), 1, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        int iProgress = 0;
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        this.m_Grids = (ArrayList)this.m_Parameters.getParameterValueAsObject(GRIDS);
        boolean bInterpolate = this.m_Parameters.getParameterValueAsBoolean(INTERPOLATE);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iShapeCount = this.m_Layer.getShapesCount();
        double[][] dValues = new double[2 * this.m_Grids.size()][iShapeCount];
        int iTotalProgress = 2 * iShapeCount * this.m_Grids.size();
        IFeatureIterator iter = this.m_Layer.iterator();
        for (int iLayer = 0; iLayer < this.m_Grids.size(); ++iLayer) {
            i = 0;
            RasterLayerAndBand rab = (RasterLayerAndBand)this.m_Grids.get(iLayer);
            IRasterLayer raster = rab.getRasterLayer();
            int iBand = rab.getBand();
            raster.setFullExtent();
            if (!bInterpolate) {
                raster.setInterpolationMethod(0);
            }
            while (iter.hasNext() && this.setProgress(iProgress, iTotalProgress)) {
                IFeature feature = iter.next();
                Geometry geom = feature.getGeometry();
                Coordinate[] coords = geom.getCoordinates();
                dValues[iLayer][i] = raster.getValueAt(coords[0].x, coords[0].y, iBand);
                dValues[iLayer + 1][i] = raster.getValueAt(coords[coords.length - 1].x, coords[coords.length - 1].y, iBand);
                ++iProgress;
                ++i;
            }
        }
        if (this.m_Task.isCanceled()) {
            return false;
        }
        Object[][] values = new Object[2 * this.m_Grids.size()][iShapeCount];
        String[] sNames = new String[2 * this.m_Grids.size()];
        Class[] types = new Class[2 * this.m_Grids.size()];
        for (i = 0; i < this.m_Grids.size(); ++i) {
            int j;
            RasterLayerAndBand rab = (RasterLayerAndBand)this.m_Grids.get(i);
            IRasterLayer grid = rab.getRasterLayer();
            sNames[i] = "1_" + grid.getName();
            types[i] = Double.class;
            for (j = 0; j < iShapeCount; ++j) {
                values[i][j] = new Double(dValues[i][j]);
            }
            sNames[i + 1] = "2_" + grid.getName();
            types[i + 1] = Double.class;
            for (j = 0; j < iShapeCount; ++j) {
                values[i][j] = new Double(dValues[i][j]);
                values[i + 1][j] = new Double(dValues[i + 1][j]);
            }
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setDescription(this.m_Layer.getName() + "[" + Sextante.getText((String)"sampled") + "]");
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)this.m_Layer, (IOutputChannel)channel, (String[])sNames, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return !this.m_Task.isCanceled();
    }
}

