/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.geometricProperties;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.shapesTools.ShapesTools;

public class GeometricPropertiesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Class[] types = new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class, Double.class};
        String[] sFields = new String[]{Sextante.getText((String)"AREA"), Sextante.getText((String)"PERIMETER"), "THICK", "APRel", "APRel2", "QDR", "FD", "RC", "SHAPE"};
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iShapesCount = layerIn.getShapesCount();
        Object[][] values = new Double[9][iShapesCount];
        IFeatureIterator iter = layerIn.iterator();
        int i = 0;
        while (iter.hasNext() && this.setProgress(i, iShapesCount)) {
            IFeature feature = iter.next();
            AreaAndPerimeter ap = this.getAreaAndPerimeter(feature.getGeometry());
            values[0][i] = new Double(ap.dArea);
            values[1][i] = new Double(ap.dPerimeter);
            values[2][i] = new Double(this.getThickness(ap));
            values[3][i] = new Double(this.getAPRelation(ap));
            values[4][i] = new Double(this.getAPRelation2(ap));
            values[5][i] = new Double(this.getQDR(ap));
            values[6][i] = new Double(this.getFD(ap));
            values[7][i] = new Double(this.getRC(ap));
            values[8][i] = new Double(this.getSHAPE(ap));
            ++i;
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setDescription(layerIn.getName());
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)layerIn, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Geometric_properties_of_polygons"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Polygons"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Polygons"), 2, LAYER);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private AreaAndPerimeter getAreaAndPerimeter(Geometry geom) {
        AreaAndPerimeter ap = new AreaAndPerimeter();
        ap.dArea = geom.getArea();
        ap.dPerimeter = geom.getLength();
        return ap;
    }

    private double getThickness(AreaAndPerimeter ap) {
        double thickness = Math.PI * 4 * ap.dArea / Math.pow(ap.dPerimeter, 2.0);
        return thickness;
    }

    private double getAPRelation(AreaAndPerimeter ap) {
        double APR = Math.pow(ap.dPerimeter, 2.0) / ap.dArea;
        return APR;
    }

    private double getAPRelation2(AreaAndPerimeter ap) {
        double APR2 = 5.0 * ap.dPerimeter / ap.dArea;
        return APR2;
    }

    private double getQDR(AreaAndPerimeter ap) {
        double QDR = 16.0 * ap.dArea / Math.pow(ap.dPerimeter, 2.0);
        return QDR;
    }

    private double getRC(AreaAndPerimeter ap) {
        double RC = Math.pow(Math.PI * 4 * ap.dArea / Math.pow(ap.dPerimeter, 2.0), 0.5);
        return RC;
    }

    private double getFD(AreaAndPerimeter ap) {
        double FD = 2.0 * Math.log(ap.dPerimeter) / Math.log(ap.dArea);
        return FD;
    }

    private double getSHAPE(AreaAndPerimeter ap) {
        double SHAPE = ap.dPerimeter / (2.0 * Math.sqrt(ap.dArea * Math.PI));
        return SHAPE;
    }

    private class AreaAndPerimeter {
        public double dArea;
        public double dPerimeter;

        private AreaAndPerimeter() {
        }
    }
}

