/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.minimumEnclosingPolygon;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.shapesTools.ShapesTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class MinimumEnclosingPolygonAlgorithm
extends GeoAlgorithm {
    private static final int CONVEX_HULL = 0;
    private static final int ME_CIRCLE = 1;
    private static final int ME_RECTANGLE = 2;
    public static final String POINTS = "POINTS";
    public static final String FIELD = "FIELD";
    public static final String METHOD = "METHOD";
    public static final String USECLASSES = "USECLASSES";
    public static final String RESULT = "RESULT";
    private int m_iMethod;
    private Geometry m_ConvexHull;
    private IVectorLayer m_Layer;
    private boolean m_bUseClasses;
    private int m_iClass;
    IVectorLayer m_Output;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        ArrayList list;
        HashMap map = new HashMap(9);
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        this.m_iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        this.m_bUseClasses = this.m_Parameters.getParameterValueAsBoolean(USECLASSES);
        this.m_iClass = this.m_Parameters.getParameterValueAsInt(FIELD);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        int iCount = this.m_Layer.getShapesCount();
        this.m_Output = this.m_bUseClasses ? this.getNewVectorLayer(RESULT, this.m_Layer.getName() + Sextante.getText((String)"[Enclosing_shape]"), 2, new Class[]{String.class}, new String[]{this.m_Layer.getFieldName(this.m_iClass)}) : this.getNewVectorLayer(RESULT, this.m_Layer.getName() + Sextante.getText((String)"[Enclosing_shape]"), 2, new Class[]{String.class}, new String[]{"ID"});
        int i = 0;
        IFeatureIterator iter = this.m_Layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            Coordinate[] coords;
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Object key = !this.m_bUseClasses ? "1" : feature.getRecord().getValue(this.m_iClass);
            list = (ArrayList)map.get(key);
            if (list == null) {
                list = new ArrayList();
                map.put(key, list);
            }
            for (Coordinate element : coords = geom.getCoordinates()) {
                list.add(element);
            }
        }
        Set set = map.keySet();
        for (Object key : set) {
            list = (ArrayList)map.get(key);
            Point[] points = new Point[list.size()];
            GeometryFactory geometryFactory = new GeometryFactory();
            for (i = 0; i < list.size(); ++i) {
                points[i] = geometryFactory.createPoint((Coordinate)list.get(i));
            }
            try {
                MultiPoint mp = new MultiPoint(points, new GeometryFactory());
                this.m_ConvexHull = mp.convexHull();
                this.generateOutput(key);
            }
            catch (Exception exception) {}
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Minimum_enclosing_shapes"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setIsDeterminatedProcess(false);
        this.setUserCanDefineAnalysisExtent(true);
        String[] sMethod = new String[]{Sextante.getText((String)"Convex_hull"), Sextante.getText((String)"Minimum_enclosing_circle"), Sextante.getText((String)"Minimum_enclosing_rectangle")};
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points"), -1, true);
            this.m_Parameters.addTableField(FIELD, Sextante.getText((String)"Field"), POINTS);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Enclosing_shape"), sMethod);
            this.m_Parameters.addBoolean(USECLASSES, Sextante.getText((String)"Create_one_polygon_for_each_class"), false);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Minimum_enclosing_shape"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void generateOutput(Object ob) {
        Object[] value = new String[]{(String)ob};
        switch (this.m_iMethod) {
            default: {
                this.m_Output.addFeature(this.m_ConvexHull, value);
                break;
            }
            case 1: {
                this.m_Output.addFeature(this.getMinEnclosingCircle(), value);
                break;
            }
            case 2: {
                this.m_Output.addFeature(this.getMinEnclosingRectangle(), value);
            }
        }
    }

    private Geometry getMinEnclosingRectangle() {
        double dMinArea = Double.MAX_VALUE;
        Polygon minRect = null;
        Coordinate[] pts = this.m_ConvexHull.getCoordinates();
        if (pts.length < 3) {
            return null;
        }
        GeometryFactory gf = new GeometryFactory();
        for (int i = 0; i < pts.length; ++i) {
            int i2 = (i + 1) % pts.length;
            double x = pts[i2].x - pts[i].x;
            double y = pts[i2].y - pts[i].y;
            double dAngle = -Math.atan2(y, x);
            AffineTransformation at = new AffineTransformation();
            at.translate(pts[i].x, pts[i].y);
            at.rotate(dAngle);
            Geometry convexHull = (Geometry)this.m_ConvexHull.clone();
            convexHull.apply((CoordinateSequenceFilter)at);
            Envelope rect = convexHull.getEnvelopeInternal();
            double dArea = (rect.getMaxX() - rect.getMinX()) * (rect.getMaxY() - rect.getMinY());
            if (!(dArea < dMinArea)) continue;
            dMinArea = dArea;
            AffineTransformation iat = new AffineTransformation();
            iat.rotate(-dAngle);
            iat.translate(-pts[i].x, -pts[i].y);
            Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
            LinearRing ring = gf.createLinearRing(coord);
            minRect = gf.createPolygon(ring, null);
            minRect.apply((CoordinateSequenceFilter)iat);
        }
        return minRect;
    }

    private Geometry getMinEnclosingCircle() {
        Coordinate[] bndry = new Coordinate[3];
        Coordinate[] pts = this.m_ConvexHull.getCoordinates();
        Circle circle = this.getMinEnclosingCircle(pts.length, pts, 0, bndry);
        Coordinate center = circle.center;
        return ShapesTools.createCircle((double)center.x, (double)center.y, (double)circle.radius);
    }

    private Circle findCenterRadius(Coordinate p1, Coordinate p2, Coordinate p3) {
        double x = (p3.x * p3.x * (p1.y - p2.y) + (p1.x * p1.x + (p1.y - p2.y) * (p1.y - p3.y)) * (p2.y - p3.y) + p2.x * p2.x * (-p1.y + p3.y)) / (2.0 * (p3.x * (p1.y - p2.y) + p1.x * (p2.y - p3.y) + p2.x * (-p1.y + p3.y)));
        double y = (p2.y + p3.y) / 2.0 - (p3.x - p2.x) / (p3.y - p2.y) * (x - (p2.x + p3.x) / 2.0);
        Coordinate c = new Coordinate(x, y);
        double r = this.distance(c, p1);
        return new Circle(c, r);
    }

    private Circle getMinEnclosingCircle(int n, Coordinate[] p, int m, Coordinate[] b) {
        Coordinate c = new Coordinate(-1.0, -1.0);
        double r = 0.0;
        if (m == 1) {
            c = new Coordinate(b[0].x, b[0].y);
            r = 0.0;
        } else if (m == 2) {
            c = new Coordinate((b[0].x + b[1].x) / 2.0, (b[0].y + b[1].y) / 2.0);
            r = this.distance(b[0], c);
        } else if (m == 3) {
            return this.findCenterRadius(b[0], b[1], b[2]);
        }
        Circle minC = new Circle(c, r);
        for (int i = 0; i < n; ++i) {
            if (!(this.distance(p[i], minC.center) > minC.radius)) continue;
            b[m] = new Coordinate(p[i].x, p[i].y);
            minC = this.getMinEnclosingCircle(i, p, m + 1, b);
        }
        return minC;
    }

    private double distance(Coordinate p1, Coordinate p2) {
        return Math.sqrt((p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y));
    }

    private class Circle {
        public Coordinate center;
        public double radius;

        public Circle(Coordinate c, double r) {
            this.center = c;
            this.radius = r;
        }
    }
}

