/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.randomVector;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.vectorTools.randomVector.RandomGeometryUtilities;

public class RandomVectorAlgorithm
extends GeoAlgorithm {
    private static final int TYPE_POLYGONS = 0;
    private static final int TYPE_LINES = 1;
    private static final int TYPE_POINTS = 2;
    public static final String RESULT = "RESULT";
    public static final String TYPE = "TYPE";
    public static final String COUNT = "COUNT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Create_random_vector_layer"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        String[] sOptions = new String[]{Sextante.getText((String)"Polygons"), Sextante.getText((String)"Lines"), Sextante.getText((String)"Points")};
        try {
            this.m_Parameters.addNumericalValue(COUNT, Sextante.getText((String)"Number_of_features_to_create"), 1, 100.0, 1.0, 2.147483647E9);
            this.m_Parameters.addSelection(TYPE, Sextante.getText((String)"Type"), sOptions);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int iShapeType;
        String[] sNames = new String[]{"ID"};
        Class[] types = new Class[]{Integer.class};
        int iCount = this.m_Parameters.getParameterValueAsInt(COUNT);
        int iType = this.m_Parameters.getParameterValueAsInt(TYPE);
        switch (iType) {
            case 0: {
                iShapeType = 2;
                break;
            }
            case 1: {
                iShapeType = 1;
                break;
            }
            default: {
                iShapeType = 0;
            }
        }
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), iShapeType, types, sNames);
        boolean is3D = false;
        RandomGeometryUtilities rgu = new RandomGeometryUtilities(12, 4, is3D);
        Envelope env = this.m_AnalysisExtent.getAsJTSGeometry().getEnvelopeInternal();
        for (int i = 0; i < iCount && this.setProgress(i, iCount); ++i) {
            Polygon geom;
            switch (iType) {
                case 0: {
                    geom = rgu.nextNoHolePolygon(env);
                    break;
                }
                case 1: {
                    geom = rgu.nextLineString(env);
                    break;
                }
                default: {
                    geom = rgu.nextPoint(env);
                }
            }
            output.addFeature((Geometry)geom, new Object[]{new Integer(i)});
        }
        return !this.m_Task.isCanceled();
    }
}

