/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.resolvePolygonHoles;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.vectorTools.resolvePolygonHoles.NearestNeighbourFinder;
import java.util.ArrayList;

public class ResolvePolygonHolesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String POLYGONS = "POLYGONS";
    private IVectorLayer m_Polygons;
    private IVectorLayer m_Output;
    private NearestNeighbourFinder m_NNF;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"ResolvePolygonHoles"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Polygons_layer"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 2);
        }
        catch (RepeatedParameterNameException repeatedParameterNameException) {
            // empty catch block
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Polygons = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_Polygons.getName(), this.m_Polygons.getShapeType(), this.m_Polygons.getFieldTypes(), this.m_Polygons.getFieldNames());
        this.m_NNF = new NearestNeighbourFinder(this.m_Polygons, this.m_Task);
        int iShapeCount = this.m_Polygons.getShapesCount();
        int i = 0;
        IFeatureIterator iter = this.m_Polygons.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            this.resolveHoles(feature);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void resolveHoles(IFeature feature) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Geometry geom = feature.getGeometry();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon poly = this.resolveHolesInSimplePolygon((Polygon)geom.getGeometryN(i));
            if (poly == null) continue;
            polygons.add(poly);
        }
        if (!polygons.isEmpty()) {
            GeometryFactory gf = new GeometryFactory();
            MultiPolygon polygonWithHoles = gf.createMultiPolygon(polygons.toArray(new Polygon[0]));
            this.m_Output.addFeature((Geometry)polygonWithHoles, feature.getRecord().getValues());
        }
    }

    private Polygon resolveHolesInSimplePolygon(Polygon polygon) {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            holes.add(gf.createLinearRing(polygon.getInteriorRingN(i).getCoordinates()));
        }
        IFeature[] holeCandidates = this.m_NNF.getClosestFeatures((Geometry)polygon);
        for (int i = 0; i < holeCandidates.length; ++i) {
            Geometry geom = holeCandidates[i].getGeometry();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry subgeom = geom.getGeometryN(j);
                if (polygon.equals(subgeom) || !polygon.contains(subgeom)) continue;
                holes.add(gf.createLinearRing(subgeom.getCoordinates()));
            }
        }
        return gf.createPolygon(gf.createLinearRing(polygon.getExteriorRing().getCoordinates()), holes.toArray(new LinearRing[0]));
    }
}

