/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.simplifyLines;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class SimplifyLinesAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String PRESERVE = "PRESERVE";
    public static final String TOLERANCE = "TOLERANCE";
    public static final String LAYER = "LAYER";
    private boolean m_bPreserve;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        double dTolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE);
        this.m_bPreserve = this.m_Parameters.getParameterValueAsBoolean(PRESERVE);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        IVectorLayer output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Generalized_lines"), 1, layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int i = 0;
        int iCount = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry simpleGeom = this.getSimpleLine(feature.getGeometry(), dTolerance);
            output.addFeature(simpleGeom, feature.getRecord().getValues());
            ++i;
        }
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Simplify_lines"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Lines"), 1, true);
            this.m_Parameters.addNumericalValue(TOLERANCE, Sextante.getText((String)"Tolerance"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addBoolean(PRESERVE, Sextante.getText((String)"Preserve_topology"), false);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Generalized_lines"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private Geometry getSimpleLine(Geometry geometry, double dTolerance) {
        Geometry simple = this.m_bPreserve ? TopologyPreservingSimplifier.simplify((Geometry)geometry, (double)dTolerance) : DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)dTolerance);
        return simple;
    }
}

