/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.smoothLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.vectorTools.smoothLines.ControlCurve;
import java.awt.Point;
import java.util.ArrayList;

public class Bezier
extends ControlCurve {
    public Bezier(Geometry geom) {
        super(geom);
    }

    static float b(int i, float t) {
        switch (i) {
            case 0: {
                return (1.0f - t) * (1.0f - t) * (1.0f - t);
            }
            case 1: {
                return 3.0f * t * (1.0f - t) * (1.0f - t);
            }
            case 2: {
                return 3.0f * t * t * (1.0f - t);
            }
            case 3: {
                return t * t * t;
            }
        }
        return 0.0f;
    }

    Point p(int i, float t) {
        float px = 0.0f;
        float py = 0.0f;
        for (int j = 0; j <= 3; ++j) {
            px = (float)((double)px + (double)Bezier.b(j, t) * this.m_X[i + j]);
            py = (float)((double)py + (double)Bezier.b(j, t) * this.m_Y[i + j]);
        }
        return new Point(Math.round(px), Math.round(py));
    }

    @Override
    public LineString getSmoothedLine(int iSteps) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        Point q = this.p(0, 0.0f);
        coords.add(new Coordinate((double)q.x, (double)q.y));
        for (int i = 0; i < this.m_X.length - 3; i += 3) {
            for (int j = 1; j <= iSteps; ++j) {
                q = this.p(i, (float)j / (float)iSteps);
                coords.add(new Coordinate((double)q.x, (double)q.y));
            }
        }
        return new GeometryFactory().createLineString(coords.toArray(new Coordinate[0]));
    }
}

