/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.smoothLines;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.vectorTools.smoothLines.ControlCurve;
import es.unex.sextante.vectorTools.smoothLines.Cubic;
import java.util.ArrayList;

public class NatCubic
extends ControlCurve {
    public NatCubic(Geometry geom) {
        super(geom);
    }

    Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }

    @Override
    public LineString getSmoothedLine(int iSteps) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        if (this.m_X.length >= 2) {
            Cubic[] X = this.calcNaturalCubic(this.m_X.length - 1, this.m_X);
            Cubic[] Y = this.calcNaturalCubic(this.m_Y.length - 1, this.m_Y);
            coords.add(new Coordinate((double)((int)Math.round(X[0].eval(0.0))), (double)((int)Math.round(Y[0].eval(0.0)))));
            for (int i = 0; i < X.length; ++i) {
                for (int j = 1; j <= iSteps; ++j) {
                    float u = (float)j / (float)iSteps;
                    coords.add(new Coordinate(X[i].eval(u), Y[i].eval(u)));
                }
            }
            return new GeometryFactory().createLineString(coords.toArray(new Coordinate[0]));
        }
        return new GeometryFactory().createLineString(this.m_Geometry.getCoordinates());
    }
}

